# One and the Same? A Systematic Literature Review of Residential Property Investor Types

Sara O¨ zogul1 $\textcircled{1}$ and Tuna Tasan-Kok1

# Abstract

This article presents a systematic literature review on residential property investor types in selected social science disciplines and critically evaluates the status quo of academic engagement within this diverse group of property market actors. A recurring critique in recent years has been the minimal acknowledgment of investor heterogeneity particularly in relation to urban development and the financialization of housing. Yet, to date, there is no systematic evidence supporting these contentions. Therefore, we conducted an exhaustive literature review of residential investment landscapes through the Web of Science citation database in the following fields: Urban and regional planning, geography, sociology, urban studies, public administration, and economics. Subsequently, we methodically searched for the types of investors addressed, and investor categories employed, in journal articles published between 2000 and 2019. Following a meta-categorization of the results, we demonstrate how existing literature differentiates investors in terms of their spatial scale of operation, size and social composition, investment object and finance, or investment and social behavior. Additionally, we highlight the key topics and issues addressed in the reviewed literature within each meta-category. We propose to turn the four meta-categories into a multidimensional analytical framework as a point of departure for a more nuanced and in-depth understanding of investor differentiations, a tool that is urgently needed in Planning Studies and related disciplines. Furthermore, we argue that mixed method approaches combining hard and quantifiable with soft behavioral investor characteristics, as well as institutional analyses combining structural considerations with actors’ agency, are indispensable to disentangle contemporary residential property market dynamics.

# Keywords

planning, systematic review, residential property investors, categories, urban development

Residential property markets represent networks of formal and informal norms, rules, and relationships through which residential property is produced and traded. This institutional perspective draws attention to property market actors whose interaction is undergoing structural change and is essential to understand economic processes and outcomes (Keogh and D’Arcy 1999). In recent years, the wider Planning and Urban Studies literature has given increased attention to property investors as a particular actor group that has expanding power and influence. Most prominently within the framework of housing financialization, scholars are concerned about investors creating unprecedented power asymmetries, indicating an emergent new phase for cities (Sassen 2009, 2015). However, some advocate for a more thorough understanding of investors, their roles, and characteristics in urban development (Raco, Livingstone, and Durrant 2019; Theurillat, R´erat, and Crevoisier 2015; Theurillat, Corpataux, and Crevoisier 2010; Nappi-Choulet 2006), and some scholars lament that much of the existing literature exhibits rather generalized perceptions of these private-sector actors (Campbell, Tait, and Watkins 2014; Adams and Tiesdell 2012a).

This article provides a state-of-the-art review of the residential investor types addressed in scientific literature and critically evaluates the status quo of academic engagement with relation to the topic. The review is based on a systematic analysis of literature on residential investment landscapes that we conducted through the Web of Science citation database following a preselection of the database’s subject categories: Urban and regional planning, geography, sociology, urban studies, public administration, and economics. The preselection intended to capture relevant angles to property investors in relation to residential urban finance and to account for potential disciplinary differences. Our inquiry resulted in 642 peer-reviewed journal articles published between 2000 and April 2019. Within these, we methodically searched for descriptions of investor types, categories, and differentiations.

We followed an inductive approach of compiling all types and existing categorizations of residential property investors that were mentioned within these 642 articles and manually grouped them to let the data “speak.” Ultimately, four thematic areas emerged to which we could assign all individual entries: it resulted in the cornerstone of our own analysis, namely, a metacategorization of existing investor types and categories employed in the literature. This meta-categorization differentiates investors in terms of their (i) spatial scale of operation, (ii) size and social composition, (iii) investment object and finance, and (iv) investment and social behavior. Additionally, we used the meta-categorization as a framework to conduct a detailed literature review, exposing the key topics addressed and connected to investors by scholars within each thematic metacategory. Thus, this article combines different levels of analysis, providing meta-categorization, an overview of residential property investor types, and a more classic literature review.

Research on financialization, understood as “the increasing dominance of financial actors, markets, practices, measurements, and narratives” (Aalbers 2017, 3), has become particularly popular in the spatial sciences and is often addressed through interdisciplinary means. The research on the financialization of housing provides valuable insights into major structural changes at the intersection of residential property markets and urban development. However, we firmly belief that a potential existence of homogenizing assumptions of investors in this thematic body of literature runs considerable risks, both in terms of the theoretical soundness of research findings and its relevance for practice. In this article, we particularly address planning scholars by underscoring potential gaps and shortcomings in planning research on residential property investors from an interdisciplinary perspective.

Our review confirms the concerns of scholars about the overall limited engagement with investor stratifications. All too often, and within all selected Web of Science subject categories, investors are treated as a homogenous actor group. Even within the 117 articles that we found mentioning a specific type of investor (Appendix), many scholars fail to define and thoroughly describe the type of investors they are naming. Elaborate categorizations or theorizations of investor types are scarce, and when differentiations are made, they frequently follow onedimensional approaches. It means that investors are often divided based on simple divisions such as global versus local investors, small versus large investors, or institutional versus individual investors. Other factors, such as the size of an investment company, the investment object, or investment strategies, are not taken into account. The dynamic and often complex positions of property investors reflecting financial market conditions are usually disregarded. Fortunately, a subset of academic articles engages more thoroughly with investors. More technical accounts especially differentiate between, for instance, types of investment finance such as bonds and private equity, and particularly in the field of Economics, behavioral aspects in investment and decision-making processes of investors are included.

Categorizing is more than a mere recognition of reality but a “process of creation itself” (Jacob 2004, 520). It has considerable ramifications for the ways in which our thinking is shaped, concepts are approached, and studies set up (Rosch 1975). Therefore, we consider our systematic review and critical reflection on investor types and categories as an essential first step to advance our knowledge on the subject. Articles in our database designate the global financial crisis (GFC) of 2008, including the processes leading up to it and its aftermath, as a most profound experience instigating structural changes in various residential property markets worldwide. The composition and strategies of actors transformed, new actors emerged on residential investment landscapes, and power relations began to alter. The more surprising it is then that many social scientists, particularly those concerned about financialization, utilize the term “investor” in a generic manner. In-depth knowledge on the connection between finance and the built environment is urgently needed (Waldron 2018).

Based on our analysis, we argue that the one-dimensional approaches that many journal articles convey are insufficient to capture the diversity of investors in today’s volatile residential property markets and hence hamper both nuanced empirical analyses and theoretical advancements on the links between finance and the residential built environment. For Planning scholars in particular, generalizations of investors in their analyses may omit crucial elements that could impact their research findings and hinder the development of tangible recommendations for practice. Not only is there a risk of further enlarging the gap between theory and practice, but a lack of specificity in relation to residential property investors in Planning research may leave practicing planners and policy makers disillusioned, and at worst defeated, in light of contemporary urban dynamics. Only when the phenomenon of residential property investors as an increasingly influential actor group in urban development is properly understood and differentiated, can practicing planners and urban policy makers make informed choices in their efforts to influence and regulate these actors.

Therefore, we consider our meta-categorization as a valuable analytical framework to think along multidimensional lines, preventing the oversimplification of investors and shedding new light on property actor and property market complexities. The framework combines both “hard” characteristics that are relatively easy to pinpoint and are often quantifiable such as the scale of operation, firm composition, or financial turnover, with “soft” characteristics requiring in-depth qualitative analyses such as on risk aversion, modes of behavior or the influence of public-sector regulation, and the nature of relationships with public-sector officials.

This article begins with an elaboration of our methodology including the process and exclusion criteria decisions taken during the systematic literature review. It is followed by a presentation of the property investor types and categories that we found in the literature, and the main topics addressed in relation to them, structured according to our fourfold metacategorization. We progress with a discussion of the necessity of a multidimensional outlook on investors and end by drawing up lessons for future research on residential investment landscapes. Overall, we contend that mixed method approaches, as well as institutional analyses combining structural considerations with actors’ agency, are indispensable to disentangle contemporary residential property market dynamics.

![](images/85eb253e273148f5d7fcb3203fd7ee222502c4edfeb839169ca036e08ce5662f.jpg)  
Figure 1. Overview of results of the systematic literature review.

# Method

Stand-alone, systematic literature reviews differ in terms of scope and rigor from conventional analyses using primary data as they summarize existent “evidence, identify gaps in current research, and provide a framework for positioning research endeavours” (Okoli 2015, 882). More important is a transparent and replicable methodological approach. The aim of the systematic review that builds the foundation for this article was to gain a comprehensive view of the literature addressing investors and investments into the residential urban built environment. The review was conducted as part of ongoing work within the framework of the WHIG Project (What is Governed in Cities: Residential Investment Landscapes and the Governance and Regulation of Housing Production),1 which examines the interrelationships between contemporary investment flows into urban property markets and the governance arrangements and public policy instruments that are designed to regulate them (“What Is Governed in Cities?—WHIG?” 2019).

We selected the publisher-independent citation database Web of Science and limited our search to peer-reviewed journal articles published between 2000 and April 2019 in the Social Science Citation Index citation database. Furthermore, we limited our search to the Web of Science categories Urban and regional planning, geography, sociology, urban studies, public administration, and economics. In Web of Science, Real Estate and Real Estate Finance literature, which represents a rather obvious choice when setting out to understand residential property, was not separately listed but subsumed under the Economics category. The time frame was deemed appropriate as it included the years leading up to the GFC and onto the latest developments captured by scientific research.

Our keyword search2 of investor/investment-related terminology with residential property/real estate/housing-related terminology in the title, abstract, or author keywords resulted in an initial 4,602 records, which we exported to an Excel file. We then manually reviewed the abstract for each record and, in cases of doubt, went through the full papers to exclude irrelevant entries. As we focused solely on anglophone literature, the most common criterion for exclusion was records that had an English title but were otherwise written in another language. Furthermore, we excluded entries that exclusively addressed commercial instead of residential or mixed-use properties and those that concentrated on investments into environmental sustainability or transportation but lacked an explicit connection to residential urban development practices. Ultimately, we established a database of 642 journal articles.

In the second step, we systematically went through the 642 articles to search for existing investor categorizations. Following an astonishingly small number of results, we decided to repeat the process and furthermore include all articles that describe or address a specific type of investor. In other words, we included all articles that only mentioned one specific type of investor, such as institutional investors, without providing a categorization or even a clear definition. We assumed that scholars who point out a specific type of investor act on the assumption that the mentioned investor differs from other types of investors. Therefore, we also extended our metacategorization linguistically to existing residential property investor categorizations and types to account for these sorts of articles within our 642 records as well. Figure 1 displays the number of entries in the six Web of Science research categories of our final database, and the number of journal articles mentioning one or more specific types of investors.3

Our inductive approach meant that we had no predefined frame of analysis when working with the selected records. Instead, while thoroughly reading the 117 articles that contained residential property investor categorizations or types, we paid special attention to detecting overarching patterns and themes. Following several rounds of (re)organizing and (re)categorizing our findings, we discerned four thematic meta-categories that we then turned into our own analytical framework. In the final step, we went through all 117 articles again to come to a final decision on assigning them to one or more of the four metacategories. Figure 2 shows the composition of meta-categories in terms of discipline, in both actual numbers and in percentages indicating relative amounts. As some articles were assigned to two meta-categories, and in rare cases, three, the total number of assigned meta-categories is 142.

![](images/5bd961b5934396f8073e8792beb1cbd22e758c63daae84ce26617ce49c6ce41e.jpg)  
Figure 2. Meta-categories assigned according to discipline: left: total number; right: percentage.

A limitation of our review is the preselection of the six Web of Science research categories in line with our specific research objectives. Furthermore, throughout the process, we realized that these research categories were at times ambiguous or overlapping. For instance, Web of Science assigned articles published in the same housing studies journal to Urban and Regional Planning, and at other times to Urban Studies, or to both. Ultimately, we decided to assign articles published in housing-related journals and those published in the journal IJURR to the Urban Studies category instead of Planning or Geography. In an effort to increase consistency, the exclusion of articles from our initial records was made according to a fixed set of criteria, yet it is important to acknowledge that it remains an act of interpretation. In the following section, we synthesize our findings according to our own meta-categorization.

# Meta-categorizing Residential Property Investor Types

We established our meta-categorization following inductive reasoning by grouping the assembled residential property investor types and categorizations thematically. The resulting four meta-categories (i) spatial scale of operation, (ii) size and social composition, (iii) investment object and finance, and (iv) investment and social behavior group the range of residential property investor types that we found in the reviewed literature. In the next step, we crystallized the key topics addressed in relation to the specific sets of investor types and provide a synthesis of the wide array of quantitative and qualitative analyses that each meta-categorization entails. Table 1 provides an overview of the analysis and structure for the discussion that follows.

# Spatial Scales of Operation

Spatial scales are frequently addressed to as “power geometries” (Massey 2004) or geographical levels at which social relationships play out and are frequently featured in social science discussions (Brenner 1998). In the wider spatial sciences, there is a long tradition of linking spatial scales, often hierarchically articulated (Brenner 2009), to the multiscalar organization of urban space and processes of social reproduction under capitalism (Harvey 1989). This trend is also visible in the burgeoning literature on financialization, in which many scholars focus on the urban scale, but also examine how the process of financialization “concerns and traverses geographical [ . . . ] scales” (Fields 2017, 2). Our systematic literature review revealed that many authors also differentiate residential property investors according to their spatial scales of operation. As our first meta-category, spatial scales of operation was assigned twenty-seven times in our database of 117 articles, of which 37 percent comes from Urban Studies records, 26 percent from Geography records, 22 percent from Economics records, and 15 percent from Urban and Regional Planning records (see Figure 2 and Appendix). Key topics addressed in this meta-category were differences between local and international, the role of intermediaries in creating interscalar investment relations, a focus on Chinese investors, and the interplay between local regulatory frameworks and international investment channels.

Table 1. Meta-categorization of Residential Investors Based on the Systematic Literature Review.   

<html><body><table><tr><td>Meta-category</td><td>Exemplary investor Types Mentioned in Articles</td><td colspan="2">Key Topics Addressed in Set of Literature</td></tr><tr><td>Spatial scales of operation</td><td>. Local investors Regional investors</td><td>：</td><td>Differences between local and international investors The role of intermediaries in creating interscalar investment</td></tr><tr><td></td><td>International investors Global investors</td><td></td><td>relations Chinese investors</td></tr><tr><td></td><td>Foreign investors</td><td></td><td>The interplay between local regulations and international</td></tr><tr><td></td><td>Overseas investors</td><td></td><td>investment channels</td></tr><tr><td>Size and social</td><td>Individual investors</td><td></td><td>Financialized subjectivities</td></tr><tr><td>composition</td><td> Super-rich and middle-class foreign</td><td></td><td>The emergence of new types of investors and their</td></tr><tr><td></td><td>investors Mom-and-pop investors</td><td></td><td>characteristics The effect of regulations on different types of investors (in terms</td></tr><tr><td></td><td>Institutional investors</td><td></td><td>of size)</td></tr><tr><td></td><td></td><td></td><td>The US foreclosure crisis related to the GFC</td></tr><tr><td>Investment object and</td><td></td><td></td><td>The connection between the GFC and institutional investors</td></tr><tr><td>finance</td><td></td><td>Buy-to-live,buy-to-rent, buy-to-leave</td><td>Institutional investors and the ascendance of buy-to-rent</td></tr><tr><td></td><td>investors</td><td></td><td>Source of investment finance and its effects on tenants</td></tr><tr><td></td><td>investors</td><td>Low-tax bracket and high-tax bracket</td><td>Mortgage securitization and the GFC Institutional capital,bonds,and the financialization of social</td></tr><tr><td></td><td>Debt and equity investors</td><td></td><td>housing</td></tr><tr><td></td><td>Private equity investors</td><td></td><td></td></tr><tr><td></td><td></td><td>Residential mortgage-backed securities</td><td></td></tr><tr><td>Investment and social</td><td>investors</td><td></td><td>Investor mindsets and risk aversion</td></tr><tr><td></td><td></td><td>Rational and irrational investors</td><td></td></tr><tr><td>behavior</td><td></td><td>Sophisticated and unsophisticated</td><td>Speculation and residential property bubbles</td></tr><tr><td></td><td>investors</td><td></td><td>Investment ethics and time horizon</td></tr><tr><td></td><td></td><td></td><td></td></tr><tr><td></td><td> Amateur investors</td><td></td><td>Relationships between investors and public-sector officials</td></tr><tr><td></td><td></td><td></td><td></td></tr><tr><td></td><td>Predatory flippers,rehabbers,“milkers&quot;</td><td></td><td></td></tr></table></body></html>

Note: GFC $=$ global financial crisis.

Scholars describe investors operating beyond the scale of their nation-state, or the nation-state in which their headquarters are located, as international (Rosato et al. 2010), foreign (Rogers, Lee, and Yan 2015), global (Searle 2014), crossborder (Eichholtz, Gugler, and Kok 2011), or overseas investors (Cook 2010). Often, this set of terminology is used interchangeably even within a single analysis. Internationally active investors are often presented as a specific investor type that is opposed to those who operate at national, regional, or local scales. Savini and Aalbers (2016), for example, differentiate between local, national, and international investors. Hoang (2018) discusses local, regional, and global investors, while DeVerteuil and Manley (2017) contrast local with overseas investors. The definition of the “local” scale, in this respect, differs from publication to publication: in some articles, it designates municipal boundaries, while in others, it refers to domestic investors operating within a particular country (Wu and Tidwell 2015; Korniotis and Kumar 2013).

The differentiation between international and other investors is often either explained or indirectly assumed based on the (expected) divergent effects of their capital in receiving cities. These effects are predominantly evaluated as negative, such as the creation of exclusionary housing markets (Cook 2010).

More broadly, Fernandez, Hofman, and Aalbers (2016, 2455) argue that “the influx of foreign investors transforms the culture of places and the sense of ownership of the city.” DeVerteuil and Manley (2017, 1310) even talk about a “residential colonization by overseas investors.” Thereby, they consider the GFC as a major event that has accelerated global foreign capital looking for guaranteed and safe returns on investment in residential property, instead of being speculative in super-prime areas of global cities such as London (DeVerteuil and Manley 2017). Others have found that foreign capital often finds its way to cities on the basis of a home bias abroad: foreign investors tend to target a “destination city with a high concentration of sourcecountry-origin residents” (Badarinza and Ramadorai 2018, 533). The other way around, foreign housing investment in Seoul has been found to be especially influenced by Koreans living overseas, creating discernible investment clusters in the city (Kim, Han, and O’Connor 2015). Regardless of its origin, once foreign capital accumulates in a city, it is said to have strong repercussions on local house prices, particularly during times of crisis (Badarinza and Ramadorai 2018).

A number of articles provide conflicting evidence by pointing out that the differences between investors operating at a global or smaller scale are rather small or diminishing.

Eichholtz, Gugler, and Kok (2011), for instance, analyzed the performance of 848 internationally diversified property companies from thirty-six countries in the period from 1996 to 2007 and found that indeed the performance gaps between national and international investors reduced over this time period. Plausible explanations for this shift are the reduction of political barriers and the development of financial instruments attractive to, and improving the position of, foreign investors: all in all, the authors write, they have “levelled the playing field for foreign property investors” (Eichholtz, Gugler, and Kok 2011, 153). A case study of foreclosures in Chelsea, Massachusetts, that studied ownership of residential properties between 1998 and 2010, also found no differences in foreclosure risks between owneroccupiers and “nonlocal investors” following the 2008 economic downturn. However, local investors were more likely to invest and sell more quickly in relation to price fluctuations and hence “experienced approximately 1.8 times the mortgage foreclosure risk of occupant-owners” (Fisher and Lambie-Hanson 2012, 351).

Another key topic addressed in the reviewed literature is the creation of novel dynamics in cities through new forms of competition and collaboration involving foreign investors. In India, for instance, municipal authorities were described as eager to attract investors from abroad to create new elite landscapes and market their cities as “global,” while creating conflicts over land and expertise with Indian property developers (Searle 2014). The relations and collaboration between municipal authorities and international investors are created “active intermediaries in the flow of capital into India” (Searle 2014, 62) and led to a “building frenzy” in the country. Similar processes have been observed in Prague, Czech Republic, where a new set of intermediaries emerged to connect both institutional and individual foreign investors to Czech property developers, to local municipal authorities, and to potential local tenants (Cook 2010). The role of intermediaries, however, is not a recent phenomenon when it comes to residential property investments: Charney (2003), for instance, describes the process of Israeli property firms creating partnerships and joint ventures with local developers and domestic and foreign banks to invest Israeli capital in Poland, Hungary, and the Czech Republic since the mid-1990s.

A more recent phenomenon is seen in property investments “especially by Asian new middle-class and super-rich investors” (Wiesel and Levin 2018, 412). Within that category, most scholarly attention is being paid to wealthy Chinese investors overseas. Focusing on a Chinese-financed residential megaproject in St. Petersburg, Russia, Dixon (2010), for example, reflects on the evolving strategy of Chinese investors in terms of targeting not only diasporic residents but the city’s wider elite. Scholars also underscore that Chinese investors predominantly shape public perceptions of foreign investors in general, are scapegoated for changes in local housing stocks, and are the target of long-standing residents’ discontent (Rogers, Wong, and Nelson 2017). These dynamics have been documented in the case of Sydney, Australia (Rogers, Wong, and Nelson 2017), and in terms of local resistance to foreign investors in Vancouver, Canada (Rogers and Koh 2017). In contrast, studies that focus on foreign investment into Chinese residential property are much more technical, analyzing hedging estimates pre- and post-GFC in different regions of China (Wu and Tidwell 2015), land and house prices, or construction costs and legal regulations affecting property production (He, Wang, and Cheng 2011).

The last key topic that emerged within the meta-category spatial scales of operation is the role of local regulations and its connection to international investors. As McGregor (2014, 173) points out, we need to understand “changing regulatory regimes over finance and urban property” and the divergent interests of actors involved in residential investments. In her analysis, she studies how remittances from displaced middle classes materialize in residential properties in Harare, Zimbabwe, and argues that convergent interests of various actors including advisors, money transfer companies, property developers, and government officials have to be scrutinized as part of the regulatory regime of diasporic investments. On the other hand, Thien Thu and Perera (2011) focus on a specific land transfer policy in Vietnam. The policy stipulates that land is first allocated to property developers by the State and later traded between developers and buyers (Thien Thu and Perera 2011). By exploring the policy’s effect in Ho Chi Minh City, they uncover how it triggered joint ventures between foreign investors and Vietnamese partners and increased speculation in the city’s housing market (Thien Thu and Perera 2011). Looking back in time, Sheng and Kirinpanu (2000) reexamine the 1997 collapse of the housing sector in Bangkok, Thailand, and argue that it was not necessarily caused by international speculation. Instead, the collapse can be attributed to decisions made on the basis of close-knit financial and social relationships “between bankers (who provide the funds), property developers (who invest the funds) and politicians (who establish the regulatory framework)” (Sheng and Kirinpanu 2000, 25). Combined, these analyses speak to the importance of regulatory regimes encompassing not only formal policy but also formal and informal actor networks and relationships and their role in affecting investment channels and the position of international investors in local processes.

The reviewed literature in the first meta-category illustrates how property investment is “a nested system of diverse investors and holdings of international scope” (Savini and Aalbers 2016, 891). It also showcases the wide range of quantitative and qualitative analyses that is needed in order to expose processes ranging from the volume of, and rationale behind, international capital flows, to the numerical and social consequences in cities, or the creation of alliances between public- and private-sector actors. Nonetheless, DeVerteuil and Manley (2017) argue that the geographies of overseas investors are especially understudied. Furthermore, over twenty years ago, Brenner (1998, 460) was critical of spatial scales that were often accompanied by “implicit, uninterrogated assumptions [ . . . lacking . . . ] explicit theorization and analysis.” We observe a similar tendency in the literature on residential investors operating at diverse spatial scales. Therefore, we urge scholars to be more explicit about their definition of scale as well as their related assumptions. Additionally, the review already points to the fact that drawing conclusions solely on the basis of an investor’s scale of operation is insufficient, as foreign investors, for instance, can be individuals or large-scale investment firms. These considerations are taken up in the following section.

# Size and Social Composition

Our second meta-category groups together investor types and categorizations that scholars make in terms of investors’ size and social composition. This meta-category is dominated by Urban Studies records with a relative share of 37 percent, followed by Economic records with 28 percent (see Figure 2 and Appendix). Geography, Urban and Regional Planning, and Sociology records make up a share between 7 percent and 15 percent (Brenner 1998). Overall, the second meta-category represents the most common focus of investor differentiations and was assigned fifty-five times. The reason is especially flourishing in literature on financialized subjectivities, which discusses how individuals’ self-perception, feelings, and actions are increasingly intertwined with financial rationales and considerations. For size, we refer to the number of individuals involved, with individual investors and large investment firms having hundreds of employees on opposite sides of the spectrum. Social composition refers to the social characteristics of an investor or investment firm, which the literature tends to link to the operating size. The reviewed literature within the second meta-category are the financialized subjectivities, the emergence of new types of investors and their characteristics, and the role of regulation supporting or hindering particular investor sizes. Furthermore, special attention is paid to the residential foreclosure crisis following the GFC in the United States and the connection between the GFC and the growth of institutional investors.

Starting at the level of the individual, our literature review demonstrates that owner-occupiers are increasingly addressed to as investors. Scholars argue that the ways in which owneroccupiers approach purchasing a house have shifted from creating a place to live in to being an investment opportunity, turning property-holding citizens “into asset-accumulating investors” (Smith 2008, 520). In many studies, the lived experience of financialization is highlighted (Fields 2017), with individuals exhibiting calculated risks and entrepreneurial logics with regards to home ownership. Gillon and Gibson (2018) focus on the emotional performances and sociomaterial expressions of “investor-occupier subjects,” and Watson (2010, 1466) embeds the “modern investor subject” into a wider shift toward an asset-based welfare system in the UK. Aalbers (2009, 36) goes even further and stipulates that “most of us are investors, whether we want—or know—it or not”: even if individuals do not own a house, they are indirectly investing through pension funds or investments by local authorities.

With financial logics gaining traction, the growing share of small-scale individual investors, such as “private sector individual-unit landlord-investors” (Walks and Clifford 2015, 1624), is also explained. While the literature still focuses on individuals, these investors are particularly active in rental markets. Only a few articles address the disposition of these individual investors in terms of age, gender, and wealth (Duxbury et al. 2015). In the United States, the characteristics of rental property owners remained relatively consistent during the 2000s: investors are mostly white and Asian homeowners, married individuals and households without children, in good health, and with a high net income and educational levels (Seay et al. 2018). Tax incentives and the potential for high returns attract novice investors to this category, even though there may be risks involved (Seay et al. 2018). As a consequence, “smallscale, non-professional housing investors” (Goldstein 2018, 1111) and “amateur investors” are increasingly involved in housing speculation (Allon and Barrett 2018).

As a specific subset of individual investors, scholars also discuss the influence of rich middle-class and super-rich investors operating in the global property market (Rogers, Lee, and Yan 2015). At times, this literature coincides with the literature on Chinese investors and their scale of operation addressed earlier. Wiesel and Levin (2018, 413), for instance, define super-rich and moderately rich Chinese investors in Sydney’s residential property as “owners of large and small businesses; the managerial elite of senior industry leaders; and relatively affluent but less senior workers in the finance industry.” Ho and Atkinson (2018) work with two categories: very wealthy and lower-middle income investors. While not specifying the monetary details of these two investor groups, they argue that counter to public perceptions, it is new middle-class investors instead of the super-rich shaping London’s property market (Ho and Atkinson 2018).

The lack of specifications and definitions in investor categories and types is overall problematic, even in records where different types of investors, such as “small investors” and “big investors” (Diappi and Bolchi 2008), are named. A refreshing exception comes from Mills, Molloy, and Zarutskie (2019, 402) who provide detailed explanations: they define large corporate investors as those that purchase more than fifty properties, medium-sized being between eleven and fifty properties, small between three and ten, and “microinvestors” between one and two properties that are not intended for personal use. Furthermore, the size of dominant residential investors has been connected to the composition of housing systems, regulations, and land ownership patterns. In Australia, for instance, diffuse land ownership, high taxes and transaction costs, planning controls, and state jurisdiction all resulted in the dominance of “smallscale petty landlordism,” while institutional investors were for the longest time absent (Berry 2000). It furthermore shows, as Berry (2000, 662) points out, that government regulation is not opposed but “facilitative and supplementary” to the Australian housing market.

Small, family-run businesses are often addressed as “momand-pop” operations in the literature. Pfeiffer and Lucio (2015), for example, contrast mom-and-pop investors with large corporations and Wall Street firms like the Blackstone Group and Colony Capital. In the foreclosure crisis in California in the United States related to the GFC, Molina (2016) found that between 2007 and 2010, mom-and-pop investors frequently seized the opportunity to enter property markets alongside larger corporate investors. Similar dynamics have been observed in

Phoenix, Arizona, where mom-and-pop operations played a crucial role in the conversion of single-family homes into rental properties (Immergluck and Law 2014). Even though small family-run investors dominated the traditional single-family home market in Phoenix for a long time, Immergluck and Law (2014) described that they are faced growing competition from larger investors who are not intending to flip homes but are increasingly interested in buy-to-rent properties (Immergluck and Law 2014).

These larger investors are primarily institutional investors, such as asset management and property investment companies, insurance companies, pension funds, and banks (Montezuma 2006), and are substantially addressed in the studies of our database. Institutional investors are particularly connected to “new global financial schemes” (Bernt, Colini, and Fo¨ rste 2017, 552) and business strategies. The entrance of institutional investors into Germany’s residential property market in the mid-2000s, for example, was “based on bargain prices, cheap mortgages and low operating and maintenance costs.” In the United States, “single-family rental Property Investment Trusts” (Chilton et al. 2018, 1) increased considerably, shaping rental housing markets throughout the country. Wissoker (2016, 536) underscores how institutional investors tend to be heavily engaged in mergers and acquisitions, “transforming relationships between financial firms and homebuilders.” The overbuilding of residential properties leading up the GFC, he argues, was closely tied to the need of construction firms “to meet stock analyst targets rather than to help feed demand for subprime mortgages.” Similarly, Tomaskovic-Devey and Lin (2011, 538) contend that the “increased size and scope of institutional investors” is intertwined with the 2008 collapse of the world financial system.

Particular concerns are expressed by scholars when it comes to institutional investors in relation to rental housing. Largescale buy-to-rent investors are “much less dependent on mortgage financing than many other types of investors” (Mills, Molloy, and Zarutskie 2019, 401). Their sources of financing tend to be cheaper, thus providing them with an advantageous position in many property markets. Mills, Molloy, and Zarutskie (2019, 401) found that institutional investors buy more properties in neighborhoods with “a larger fraction of individuals with lower credit scores,” as low credit scores prevent these individuals from getting mortgages and hence increase their likelihood to rent.

The literature review within the second meta-category demonstrates the potential variety of residential property investors in terms of size and social composition. Financial ideologies penetrating public and private life further add to existing market complexities, as more individuals are drawn to residential property investments. Despite general trends indicated by existing research, our findings should caution scholars to draw hasty conclusions on residential investors. Ultimately, a mix of quantifiable measurements and qualitative judgments is needed to pinpoint an investor’s size and social composition and its relation to specific regulatory frameworks and housing market contexts. Furthermore, there may be a correlation between the size and social composition of investors and their investment targets and financial means (Immergluck and Law 2014), which is addressed in the following section.

# Investment Object and Finance

The literature reviewed in our third meta-category differentiates residential investors in terms of their investment object and finance. The investment object refers to the target of investments, such as housing for owner-occupation or properties for rental purposes. With investment finance, we refer to the utilized source of financial capital such as equity or debt. Both tend to be inextricably linked. The intricate process of property investments often lacks scrutiny in Urban Planning literature (Adams and Tiesdell 2012b), and almost half (48 percent) of this metacategory exists of Economics entries (see Figure 2 and Appendix). Interestingly, this number is closely followed by Urban and Regional Planning entries amounting to a share of 30 percent. This is the highest share of Urban and Regional Planning entries among all meta-categories. Geography entries, for example, are not represented at all. Key topics addressed by scholars in this meta-category are the ascendance of buy-to-rent, the available source of investment finance for large-scale investors, and the consequent (adverse) effects on tenants. Alongside that, the securitization of mortgages and its role in the GFC are prominently discussed, as well as the utilization of institutional capital and bonds in social housing provision within the framework of financialization.

Scholars such as Kriese and Scholz (2012) differentiate broadly between commercial and noncommercial investors and include housing cooperatives, the nonprofit sector and public investors targeting affordable housing production for less affluent people as investment objects in the latter group. Another common differentiation is made in terms of “buy-to-live,” “buy-to-rent,” or—as it is at times called in the case of superrich investors—“buy-to-leave” properties (Fernandez, Hofman, and Aalbers 2016), which are seen as investment objects. As indicated in the previous section, buy-to-rent properties are particularly discussed in relation to institutional investors (Mills, Molloy, and Zarutskie 2019). In the US context, in the wake of the GFC, investments into foreclosed properties for the purpose of transforming them into rental housing emerged as a subcategory of buy-to-rent properties as investment objects. And even though a wide range of investors including owner-occupants or mission-driven organizations purchased foreclosed properties, large institutional investors made up the biggest share as they had “greater access to financing and ability to pay cash” (Lambie-Hanson et al. 2019, 239).

With regard to investment finance, Wood and Tu (2004) differentiate between low-tax bracket and high-tax bracket investors into residential property. They consider the former as investors who put money into low-value rentals with the intention to attract rents that are high in relation to the property value, and the latter as investors who invest into high-value housing charging rents that are rather low in relation to property values (Wood and Tu 2004). Besides tax brackets, Coiacetto and Bryant (2014) argue that there is a crucial difference between debt and equity investors. Debt investors retrieve their investment finance “generally by way of a registered mortgage” (Coiacetto and Bryant 2014, 308), while equity investors participate in both risks and revenues of the final product, in this case residential property. For example, if a large-scale residential property development turns out not to be financially viable, generally equity investors have neither the legal rights for repayment of their investment nor for expected or promised returns. In relation to equity investors, Fields and Uffer (2016, 1489) argue that “private equity’s high yield targets may adversely affect tenants” as private equity investors maximize high, short-term returns over risk and cut back on services and repairs to reduce costs.

Changes in the regulation of mortgages as a common type of investment finance for residential properties are also addressed in the literature. Aalbers (2009) explains how the securitization of mortgages served as a strategy to remove risk and to allow nonbanks to enter the market. Securitization also “enabled mortgage income to be sold to institutional investors as bonds” (Wainwright and Manville 2017, 819) and “to channel capital from a growing range of investors to development” (Coiacetto and Bryant 2014, 308). These financial innovations that precede the GFC meant that “mortgage portfolios could now be sold to investors anywhere in the world” (Aalbers 2009, 35). As mortgage portfolios were perceived as low risk, they became popular (Aalbers 2009). Residential mortgage-backed securities are addressed by several scholars. Piskorski, Seru, and Witkin (2015, 2636), for example, who discuss investors operating in the “nonagency residential mortgage-backed securities market” that “originated without government guarantees” and point out issues with contractual closures by intermediaries during mortgage sales. Bertus, Hollans, and Swidler (2008) focus on mortgage portfolio investors, who were found to be highly susceptible to falling house prices and mortgage default rates after prolonged periods of missed payments by borrowers (Bertus, Hollans, and Swidler 2008). Facing challenges to predict future payments (Clapp et al. 2001), “investor appetite for securitized real-estate bonds declined markedly” (Wainwright and Manville 2017, 820) after the GFC.

The last key topic in this meta-category focuses on social housing as an investment object and the growing prominence of utilizing institutional investments to finance it. As Tang, Oxley, and Mekic (2017, 411) argue, “for institutional investors, investing in social housing is a profit-oriented business as well as a corporate social activity that creates public relations benefits.” Wainwright and Manville (2017, 819) argue that financialization has entered the third sector since 2009, when “a new type of real-estate bond market has grown in London, enabling social housing groups to issue bonds.” Thus, profit orientation in social housing essentially links commercial sources of finance to noncommercial investment objects.

Scholars differentiating investors on the basis of investment object and finance add another layer of complexity. Diverse interests of investors in terms of investment objects crystallize, with several niches such as build-to-rent gaining traction among particular investor types. Furthermore, changes leading to and following the GFC illustrate how investment finance is entrenched in a global financial system, and how it consists of different sources of financial capital available to investors of different sizes and operating at different spatial scales. Indepth knowledge of financial regulations, financial markets, and investment rationales have to be coupled with quantitative data on investor holdings and transaction volumes in terms of property and capital types to discern differences between investors. It might require scholars without a background in Economics to enter unfamiliar research terrain and to utilize unfamiliar data sources. Nonetheless, these efforts are indispensable to understand and address the volatility of residential urban development. To gain a truly comprehensive view of an investor, these considerations should be supplemented with a focus on investment strategies and social behavior, as discussed in the following section.

# Investment and Social Behavior

Moving on from the more technical discussion, investor types in this last meta-category are differentiated based on the aforementioned investment and social behavior. A profound 70 percent of the reviewed literature in this meta-category comes from Economics records, while Urban and Regional Planning records are entirely absent (see Figure 2 and Appendix). Many of the Economics articles in our database are from the field of behavioral economics, a research focus that stems from the realization that traditional finance theory is insufficient to explain investor behavior (Hei-Ling Lam and Chi-Man Hui 2018). Within this field, it is widely accepted that investor sentiment extends beyond rational calculations and is a key driving force of housing market dynamics (Dieci and Westerhoff 2016; Hui, Zheng, and Wang 2013). Specific key topics that scholars address within the fourth meta-category are bounded rationality and behavioral heterogeneity of housing market investors (Dieci and Westerhoff 2016), centered on investor mindsets and risk aversion, speculation and property bubbles, investment ethics and time horizons, as well as the relationships between investors and public-sector officials.

Rationality is centrally featured in several accounts, and differentiations between rational and irrational investors concluded (Hayunga and Lung 2011). The recent financialization literature strongly underscores how home buyers exhibit rational economic and calculative considerations instead of simply looking for a place to live (Gillon and Gibson 2018). However, Clark, Duran-Fernandez, and Strauss (2010) argue that debates on whether investors are rational or irrational are redundant, as rationality represents a general human trait. Instead, they pose that “domains that are subject to risk and uncertainty demand a level of sophistication that goes beyond basic levels of competency, learning-by-doing and learning-by-interacting” (Clark, Duran-Fernandez, and Strauss 2010, 334). Indeed, risk is the most commonly explored theme connected to rationality. According to Hui, Zheng, and Wang (2013), risk aversion is an intrinsic investor trait that is not changing easily. Mok (2002, 1095) points out that residential property investors tend to be more risk averse than other investors following “a belief that housing assets are a hedge against inflation.”

Residential investments attract larger numbers of “unsophisticated investors,” as it appears to require less specialization and financial knowledge than other investments (Hui, Zheng, and Wang 2013). On the contrary, however, Leung and Tse (2017) highlight the importance of knowledge and insight into market dynamics on the basis of a simulation of investment outcomes for “informed” and “uninformed” investors. Similarly, Hwang and Quigley (2010) address the influence of informational advantage on investment outcomes. Nonetheless, large numbers of “amateur investors” tend to operate in residential property markets and contribute to the “behavioral dynamics of asset bubbles” (Earl, Peng, and Potts 2007, 351). Earl, Peng, and Potts (2007) utilize the metaphor of a contagious disease and explain that “the more people who seem to be using a decision rule, the more people will adopt it and so, because of that, the more the decision rule will appear to be delivering its expected results.” Uninformed, amateur investors seem particularly influenced by herd instincts in investment.

According to Clark, Duran-Fernandez, and Strauss (2010), residential property market players can be divided into four categories: “sophisticated investors” focus on low-risk investment strategies, predominantly operate as a global scale with a long-term time horizon (Clark, Duran-Fernandez, and Strauss 2010); “opportunistic investors” gamble and make uninformed decisions, operate at a global scale but with a short-term time horizon (Clark, Duran-Fernandez, and Strauss 2010); “naive planners,” operating at a local scale, tend to get “caught-up in the irrational exuberance of the moment notwithstanding a range of intended long-term savings options” (Clark, DuranFernandez, and Strauss (2010, 356); and lastly, “myopic investors” operating at the local scale easily overload on property and shortsightedly follow property market cycles. Of all investor categorizations found in our systematic literature review, this modeling by Clark, Duran-Fernandez, and Strauss (2010) is the most comprehensive one, following a multidimensional approach of addressing spatial scale, temporality, and investment behavior simultaneously.

Another key theme addressed in the reviewed literature within this meta-category is the speculative behavior of investors who engage in risky investment behavior as they prioritize short-term capital gains (Dieci and Westerhoff 2016). This form of speculation has been shown to strongly impact house price dynamics (Zheng et al. 2017). Investors engaging in speculation are also called “noise-traders” and characterized as irrational (Hei-Ling Lam and Chi-Man Hui 2018).

On the basis of a case study of the then bursting housing bubble and the foreclosure crisis in connection to the GFC in Las Vegas, Nevada, Mallach (2014) further differentiates investor behavior beyond speculation. He exposes four main investment strategies in Las Vegas, with “rehabbers” upgrading dilapidated houses before resale, and “market-edge flippers” utilizing market knowledge and access to properties to resell houses with a profit (Mallach 2014). The “predatory flippers,” on the other hand, aim for fast profit through unethical and illegal practices, “often using inflated values and collusion between buyers, realtors, and mortgage originators” (Mallach 2014, 769). And lastly, the “milkers” buy houses in poor condition and offer them to rent often to problem tenants with only minimal maintenance.

The final key topic emerging from the literature review is relationships between investors and public-sector officials, which brings social behavior into play. As Raco, Livingstone, and Durrant (2019, 1070) contend, the regulation of the urban built environment is much more than official policies and legally binding rules but includes “reflexive forms of negotiation and performance.” In a similar vein, Hoang (2018) conceptualizes different types of relationships between investors and publicsector officials. Even though these types do not directly refer to investors themselves, they are nonetheless interesting as the interaction between state and market actors represents a recurring theme throughout this review. Drawing on data from 100 interviews with players in Vietnam’s property market, Hoang (2018, 657), for example, argues that the relationship between investors and their proximity to public-sector officials depends on “legal/regulatory, social ties, cultural matching, and stage of investment” and can be divided into relationships “of patronage (predatory), mutual destruction (mutual hostage), or transparency (developmental).”

The vivid discussions on investor behavior make it hard to believe that “within writings on financialization there is a tendency to see this group of actors as acquisitive and focused on economic calculations and rationalities” (Raco, Livingstone, and Durrant 2019, 1069). Scholars writing on financialization without taking investors’ strategies and social behavior into account run the risk of overlooking crucial elements in their research. Even though this meta-category on investment and social behavior is dominated by Economics entries, qualitative or mixed-methods inquiries supersede quantitative analyses. This qualitative emphasis makes the low representation of Urban Studies, Geography, and Sociology studies, and the absence of Urban and Regional Planning entries in this metacategory, even more surprising. It seems as if the discussions on investor behavior have not permeated successfully from Economics to the other disciplines incorporated in our systematic review, underscoring the need for more interdisciplinary work addressing residential property investment.

# Discussion and Conclusion

This article provided a comprehensive overview of residential property investor types and differentiations engaged within the existing social science literature, and a review and synthesis of key topics addressed in relation to these residential property investors. As criticism on the dominance of accounts representing investors as a homogenous group is slowly gaining momentum (Raco, Livingstone, and Durrant 2019), we aim to contribute to this critical development by providing evidence for these claims in the form of our systematic literature review. Additionally, by employing an interdisciplinary approach and by mapping the diversified academic engagement with residential property investors, we hope to inspire and stimulate new research avenues that capture actual investor heterogeneity.

The four meta-categories on investor types that emerged inductively through our work structured our own review and analysis. While records from our database were at times assigned to two or more meta-categories, the number of articles addressing solely one remains striking. In fact, our initial target of only including fully fledged investor categories led to disappointing results, with the number of articles that contained clear definitions and characteristics of different types of investors reaching around twenty. After readjusting our search criteria to broaden our focus to also include articles that simply mention one or more specific type(s) of investors even without elaborate explanations, we were able to increase our search results considerably. Nonetheless, assessing the 117 selected articles in light of the complete database on residential investment that we created, they only constitute approximately 18 percent, which still seems rather limited. A very simple takeaway for academics addressing investors in this respect is the inclusion of a clear definition of the respective investor featured in their analysis.

The use of Web of Science research categories as proxy for academic disciplines is open for discussion, but they added an interesting layer of analysis to our review. Especially articles published in the field of Urban and Regional Planning, Geography, and Urban Studies were difficult to separate as all these fields are partly merged and are already quite interdisciplinary in character. Ultimately it was not so relevant as the most striking differences existed between these three research fields and the field of Economics. In the latter, authors strongly focused on the behavioral aspects of investors, while these discussions were rather limited or entirely absent in the other disciplines. Therefore, not only do we support scholars’ critiques on this specific aspect that is lacking in the wider Planning and Urban Studies, but it is also the point where we see the most potential for transdisciplinary knowledge transfers.

Another rather unexpected result was the limited number of Public Administration articles addressing residential investment landscapes in general, and the complete absence of articles identifying types of investors in particular. As it seems that an evergrowing amount of public administrations and particular local municipal governments struggle with issues around housing supply, housing affordability, and the finance of new housing production, one would expect stronger academic engagement with the topic in this field. As many records in our analysis point out, public authorities at all levels and public regulation and policies play a fundamental role in residential investments. Our review demonstrates how global investment dynamics and rationales shape local housing markets but also illustrates that government officials are not powerless in the face of the market. On the contrary, as the reviewed literature shows, public authorities were deeply embedded in enabling, regulating or constraining specific types of investors and investment practices.

Each one of our meta-categorizations presented illuminating insights and results from research conducted on investors to this day. However, it also became rather obvious that solely focusing on one of them to define an investor would miss out on other influential elements. Throughout this article, we shed light on the intricate links and connections between all metacategories. We also illustrate that it is almost impossible to draw conclusions on investors by solely focusing on one characteristic, such as their scale of operation, without considering other important dimensions. Therefore, we propose to utilize our meta-categorization as a multidimensional analytical framework to suggest a pragmatic step forward and to counter the shortcomings of existing literature on residential property investors. Even though we are fully aware that all aspects incorporated in this literature review cannot be addressed simultaneously and thoroughly in every study but reflecting on the four broad meta-categories can provide a valuable reminder for researchers to consider possible differentiations that may have repercussions on their analysis. As such, more nuanced analyses can be produced that do not tip into overgeneralizations and eventual stereotypes, while benefiting from interdisciplinary insights.

Additionally, special attention within this framework should be paid to the regulatory context and wider structuring forces that scholars have addressed, such as financial deregulation and the embeddedness of local housing markets in a global financial system. On the other hand, the reviewed literature illustrated a number of interesting findings in relation to actors’ agency, which should be consciously incorporated as well. For example, the roles and connections between middle-men, financial advisers, brokers, and government officials bear potential to be scrutinized further, as well as the influence of public policy on (the creation of) specific types of investors. An institutional approach to residential property markets and market actors, as addressed in the beginning of this article, provides a good point of departure: an institutional analysis combines interlinking norms, rules, and regulations with diverse relationships between types of actors and actor agency leading to heterogeneous residential property market processes.

As we have shown in this article, public- and privatesector dynamics, with residential property investors at the forefront, are not clearly separated and opposed from one another but intertwined in multiple, overlapping, and contradictory ways. Disentangling these complexities and providing actionable strategies based on a thorough understanding of regulations, market dynamics, and actors become indispensable in efforts to understand and address widespread housing supply and affordability issues. Thereby, we also advocate for a combination of quantitative and qualitative analyses as our meta-categorization combines both hard and soft investor characteristics. We believe that it is extremely valuable to combine qualitative research on investors with financial data sets, and vice versa, to move beyond simplified conclusions and hasty correlations. It would be folly to lump all residential property investors together; they are far beyond one and the same.

Appendix Full Overview and Categorization of Journal Articles Mentioning One or More Specific Types of Investors.   

<html><body><table><tr><td></td><td>Author/s (Year)</td><td>Journal</td><td>Type/s of Investors Mentioned</td><td>Assigned Meta-categorization</td></tr><tr><td>Urban and Regional Planning</td><td>Diappi and Bolchi (2008)</td><td>Computers,Environment and Urban Systems</td><td>Small investors; big investors</td><td>Size and composition</td></tr><tr><td></td><td>Smith (2008)</td><td>A</td><td>Environment and Planning Asset-accumulating owner-occupied investors</td><td>Size and composition</td></tr><tr><td></td><td>Immergluck (2009)</td><td>Journal of the American Planning Association</td><td>Mortgage-backed securities investors</td><td>Investment object and finance</td></tr><tr><td></td><td>Voigtlander (2009)</td><td>Housing Studies</td><td> Private investors</td><td>Size and composition</td></tr><tr><td></td><td>Rosato et al. (2010)</td><td>Journal of Environmental Planning and</td><td>International investors</td><td>Scale of operation</td></tr><tr><td></td><td></td><td>Management</td><td>He,Wang,and Cheng (20lI） Annals of Regional Science Foreign direct real estate investors</td><td>Scale of operation</td></tr><tr><td></td><td>Walks and Clifford (2015)</td><td>A</td><td>Environment and Planning Private-sector individual-unit landlord investors</td><td>Size and composition; investment object and finance</td></tr><tr><td></td><td>Fernandez, Hofman,and Aalbers (2016)</td><td>A</td><td>Environment and Planning Buy-to-let elite investors; buy-to-live investors; buy-to-eave investors</td><td>Investment object and finance</td></tr><tr><td></td><td>Stevens (2016)</td><td>Built Environment</td><td>Journal of Housing and the Institutional investors;small rental investors</td><td>Investment object and finance</td></tr><tr><td></td><td>Teresa (2016)</td><td>Environment and Planning Private equity investors A</td><td></td><td>Investment object and finance</td></tr><tr><td></td><td>Tang, Oxley,and Mekic (2017)</td><td>Housing Studies</td><td>Institutional investors; bond investors</td><td> Size and composition; investment</td></tr><tr><td></td><td>DeVerteuil and Manley</td><td>van Loon and Aalbers (2Ol7) European Planning Studies Institutional investors Environment and Planning Overseas investors</td><td></td><td>object and finance Size and composition</td></tr><tr><td></td><td>(2017)</td><td>A</td><td></td><td>Scale of operation</td></tr><tr><td></td><td>Wainwright and Manville (2017)</td><td>A</td><td>Environment and Planning Bond investors; equity investors</td><td>Investment object and finance</td></tr><tr><td></td><td>Raco, Livingstone,and Durrant (2019)</td><td></td><td>European Planning Studies International investor; institutional investors; buy-to-let investors</td><td>Scale of operation; size and composition; investment object</td></tr><tr><td>Geography</td><td>Aalbers (2009)</td><td>Area</td><td>Individual investors; passive investors;</td><td>and finance Size and composition; investment</td></tr><tr><td></td><td>Clark,Duran-Fernandez,and Journal of Economic</td><td></td><td>low-risk investors Sophisticate,opportunist, myopic, naive Investment behavior</td><td>behavior</td></tr><tr><td></td><td>Strauss (2010) Dixon (2010)</td><td>Geography Eurasian Geography and</td><td>planner investors Foreign direct investors</td><td></td></tr><tr><td></td><td>Immergluck and Law (2014)</td><td>Economics Urban Geography</td><td>Local investors; out-of-state investors;</td><td>Scale of operation Scale of operation; size and</td></tr><tr><td></td><td>McGregor (2014)</td><td>Geoforum</td><td>“mom-and-pop” investors Diaspora investors</td><td>composition Scale of operation</td></tr><tr><td></td><td>Pfeiffer and Lucio (2015)</td><td>Urban Geography</td><td>Small “mom-and-pop”operations; large Size and composition corporations; wall street firms</td><td></td></tr><tr><td></td><td>Rogers,Wong,and Nelson (2017)</td><td>Australian Geographer</td><td>Foreign investors</td><td>Scale of operation</td></tr><tr><td></td><td>August and Walks (2018)</td><td>Geoforum</td><td>Institutional investors (private equity</td><td>Size and composition</td></tr><tr><td></td><td>Fields (2018)</td><td>Economic Geography</td><td>funds; REITS; hedge funds) Institutional investors</td><td>Size and composition</td></tr><tr><td></td><td>Gillon and Gibson (2018)</td><td>Emotion,Space and Society</td><td>Rational investor-occupier subject</td><td>Size and composition; investment behavior</td></tr><tr><td>(2018)</td><td>Rogers, Nelson,and Wong</td><td>Geographical Research</td><td>Domestic investors; foreign investors</td><td>Scale of operation</td></tr><tr><td></td><td>Waldron (2018)</td><td>Geoforum</td><td>Transnational/international/global, institutional, private equity investor</td><td>Scale of operation; size and composition</td></tr><tr><td></td><td>Wiesel and Levin (2018)</td><td>Geographical Research</td><td>Foreign investors: Asian new middle- class and super-rich</td><td>Scale of operation; size and composition</td></tr><tr><td>Sociology</td><td>Tomaskovic-Devey and Lin</td><td>American Sociological</td><td>investors Institutional investors</td><td>Size and composition</td></tr><tr><td></td><td>(2011) Allon and Barrett (2018)</td><td>Review Distinktion: Journal of</td><td>Large commercial investors;</td><td>Size and composition</td></tr><tr><td></td><td>Chilton et al. (2018)</td><td>Societies Social theory</td><td>institutional investors Institutional investors; individual investors</td><td>Size and composition</td></tr></table></body></html>

Appendix. (continued)   

<html><body><table><tr><td>Author/s (Year)</td><td> Journal</td><td>Type/s of Investors Mentioned</td><td>Assigned Meta-categorization</td></tr><tr><td>Goldstein (2018)</td><td>American Sociological Review</td><td>Relationships of patronage,mutual destruction,or transparency</td><td>Investment behavior</td></tr><tr><td>Hoang (2018)</td><td>American Sociological</td><td>Private-sector individual-unit landlord</td><td>Size and composition; investment</td></tr><tr><td>Berry (2000)</td><td>Review Housing Studies</td><td>investors Small landlords;institutional investors</td><td>object and finance Size and composition</td></tr><tr><td>Sheng and Kirinpanu (2000)</td><td>Housing Studies</td><td>International/foreign investors;</td><td>Scale of operation; size and</td></tr><tr><td>Mok (2002)</td><td> Urban Studies</td><td>institutional investors Levels of risk-aversion of investors</td><td>composition Investment behavior</td></tr><tr><td>Charney (2003)</td><td>JURR</td><td> Local investors; foreign investors</td><td>Scale of operation</td></tr><tr><td>Berry and Hall (2005)</td><td>Urban Studies</td><td>Large professional institutional</td><td> Size and composition</td></tr><tr><td>Montezuma (2006)</td><td></td><td>investors; small individual investors</td><td></td></tr><tr><td>Cook (2010)</td><td>Housing Studies</td><td>Institutional investors</td><td>Size and composition Scale of operation</td></tr><tr><td>Watson (2010)</td><td>JURR Housing Studies</td><td>Foreign/overseas investors Private investor subjects</td><td>Size and composition</td></tr><tr><td>Thien Thuand Perera (20ll）Habitat International</td><td></td><td>Foreign investors</td><td>Scale of operation</td></tr><tr><td>Kriese and Scholz (2012)</td><td>Housing Theory and</td><td>Commercial investors; housing</td><td>Size and composition; investment</td></tr><tr><td></td><td>Society</td><td>cooperatives; nonprofit sector; public authority</td><td>object and finance</td></tr><tr><td>Wood and Ong (2013)</td><td>Urban Studies</td><td>Middle-aged,younger, (un)sophisticated Size and composition; investment and leveraged loss-making investors</td><td>behavior</td></tr><tr><td></td><td></td><td>Coiacetto and Bryant (20l4)Urban Policy and Research Equity investors; debt investors; small and individual investors</td><td> Investment object and finance; size</td></tr><tr><td>Hui and Wang (2014)</td><td>Habitat International</td><td>Sentiment-driven investors</td><td>and composition Investment behavior</td></tr><tr><td>Mallach (2014)</td><td>Housing Policy Debate</td><td>Predatory flipper; market edge flipper；Investment behavior rehabber; milker</td><td></td></tr><tr><td>Searle (2014)</td><td>IJURR</td><td>National real estate developers; foreign Scale of operation</td><td></td></tr><tr><td>Kim, Han,and O&#x27;Connor (2015)</td><td>CITIES</td><td>investors Foreign/global investors</td><td> Scale of operation</td></tr><tr><td>Rogers,Lee,and Yan (2015)</td><td>Housing Studies</td><td>Individual foreign investors: rich middle- Scale of operation; size and</td><td>composition</td></tr><tr><td>Fields and Uffer (2016)</td><td>Urban Studies</td><td>class and super-rich investors Institutional investors; private equity</td><td>Size and composition; investment behavior</td></tr><tr><td>Guironnet, Attuyer,and Halbert (2016)</td><td>Urban Studies</td><td>investors; risk-oriented investors Financial investors; institutional</td><td>Investment object and finance; size</td></tr><tr><td>Molina (2016)</td><td>Journal of Urban Affairs</td><td>investors &quot;Mom-and-pop” investors; large-scale</td><td>and composition Size and composition</td></tr><tr><td>Savini and Aalbers (2016)</td><td>European Urban and</td><td>corporate investors Local, national, international investors;</td><td>Scale of operation; size and</td></tr><tr><td>Stevens (2016)</td><td>Regional Studies Journal of Housing and the Institutional investors</td><td>individual and institutional investors</td><td>composition Size and composition</td></tr><tr><td>Wissoker (2016)</td><td>Built Environment Housing Policy Debate</td><td>Institutional investors</td><td> Size and composition</td></tr><tr><td>Bernt, Colini,and Forste</td><td>IJURR</td><td>Institutional investors; private equity</td><td>Size and composition; investment</td></tr><tr><td>(2017) Hulse and Reynolds (2018)</td><td>Urban Studies</td><td>investors; financial investors Household investors</td><td>object and finance Size and composition</td></tr><tr><td>Kim (2017)</td><td>International Journal of</td><td>Foreign/global investors</td><td>Scale of operation</td></tr><tr><td></td><td>Housing Policy</td><td></td><td></td></tr><tr><td>Ley (2017)</td><td>International Journal of Housing Policy</td><td>Foreign investors</td><td> Scale of operation</td></tr><tr><td>Martin (2017) Tang， Oxley,and Mekic</td><td>Housing Studies</td><td>Property investor subjects</td><td>Size and composition</td></tr><tr><td>(2017)</td><td>Housing Studies</td><td>Institutional investors</td><td> Size and composition</td></tr><tr><td>Ho and Atkinson (2018)</td><td>Urban Studies</td><td>Very wealthy investors; lower-middle income investors</td><td>Size and composition</td></tr><tr><td>Hei-Ling Lam and Chi-Man Hui (2018)</td><td>Habitat International</td><td>Rational investors (fundamentalists); noise trader/speculators</td><td>Investment behavior</td></tr><tr><td>Lambie-Hanson et al. (2019)</td><td></td><td>(irrationals)</td><td></td></tr><tr><td>Cooper, Downs,and</td><td>Cityscape Journal of Real Estate</td><td>Foreclosed property investors Informed and uninformed investors</td><td>Investment object and finance Investment behavior</td></tr><tr><td>Patterson (2000)</td><td>Finance and Economics</td><td></td><td></td></tr><tr><td>Clapp et al. (2001) Cocco (2005)</td><td>Real Estate Economics The Review of Financial</td><td>Mortgage investors High and low financial net worth</td><td>Investment object and finance Size and composition</td></tr><tr><td></td><td>Studies</td><td>investors</td><td></td></tr><tr><td>Wood and Tu (2004)</td><td>Real Estate Economics</td><td> Low-tax bracket investors; high-tax</td><td>Investment object and finance</td></tr></table></body></html>

Appendix. (continued)   

<html><body><table><tr><td>Author/s (Year)</td><td> Journal</td><td>Type/s of Investors Mentioned</td><td>Assigned Meta-categorization</td></tr><tr><td>Cheng (2005)</td><td>Finance and Economics</td><td>The Journal of Real Estate Rational investors; inexperienced investors</td><td>Investment behavior</td></tr><tr><td>Pagliari, Scherer,and Monopoli (2005)</td><td>Real Estate Economics</td><td>Large and small investors; institutional investors; tax-exempt investors</td><td> Size and composition</td></tr><tr><td>Quigley (2006)</td><td>Journal of Housing Economics</td><td>Institutional and portfolio investors; hedge funds; individual property</td><td>Size and composition</td></tr><tr><td>Earl, Peng,and Potts (2007)</td><td>Journal of Economic</td><td>investors Rational investors</td><td>Investment behavior</td></tr><tr><td>Lin and Vandell (2007)</td><td>Psychology Real Estate Economics</td><td>Long-term investors;short-term</td><td>Investment behavior</td></tr><tr><td>Benjamin et al. (2008) Bertus,Hollans,and Swidler</td><td>Real Estate Economics</td><td>investors Rental investors; appreciation investors Investment object and finance The Journal of Real EstateMortgage portfolio investors</td><td>Investment object and finance</td></tr><tr><td>(2008) Brown, Schwann,and Scott</td><td>Finance and Economics</td><td>Rental income investors; long-term,</td><td>Investment object and finance;</td></tr><tr><td>(2008)</td><td>Real Estate Economics</td><td>short-term,first and seasoned investors</td><td>investment behavior</td></tr><tr><td>Brunnermeier and Julliard (2008)</td><td>The Review of Financial Studies</td><td>Institutional investors; professional investors; (ir)rational investors</td><td>Size and composition; investment behavior</td></tr><tr><td>Brounen and Ben-Hamo (2009)</td><td>The Journal of Real Estate Institutional investors Finance and Economics</td><td></td><td>Size and composition</td></tr><tr><td>Fisher, Ling,and Naranjo (2009)</td><td>Real Estate Economics</td><td>Institutional investors</td><td>Size and composition</td></tr><tr><td>Hwang and Quigley (2010)</td><td>Finance and Economics</td><td>The Journal of Real Estate Informed investors;uninformed</td><td>Investment behavior</td></tr><tr><td>Oikarinen (2010)</td><td></td><td>investors The Journal of Real Estate Foreign/international investors</td><td> Scale of operation</td></tr><tr><td>Van Hemert (2010)</td><td>Finance and Economics Real Estate Economics</td><td>Risk-averse investors; risk-tolerant</td><td> Investment behavior</td></tr><tr><td>Brown et al. (2011)</td><td>Economic Record</td><td>investors Owner occupiers; individual property</td><td> Size and composition</td></tr><tr><td>Eichholtz, Gugler,and Kok (2011)</td><td></td><td>investors (landlords) The Journal of Real Estate Cro-border/foreign/international</td><td>Scale of operation</td></tr><tr><td>Fisher and Lambie-Hanson</td><td>Finance and Economics Real Estate Economics</td><td>investors Occupant-owners; local investors;</td><td>Size and composition; scale of</td></tr><tr><td>(2012) Hayunga and Lung (2011)</td><td>Real Estate Economics</td><td>nonlocal investors Speculative investors; irrational</td><td>operation Investment behavior</td></tr><tr><td>Chernobai and Hossain (2012)</td><td>Real Estate Economics</td><td>investors Individual investors; long-horizon</td><td> Size and composition; investment</td></tr><tr><td>Cho, Hwang,and Satchell</td><td></td><td>investors; short-horizon investors The Journal of Real EstateMortgage loan investors</td><td>behavior Investment object and finance</td></tr><tr><td>(2012) Hardin, jiang,and Wu (20l2) Journal of Real Estate</td><td>Finance and Economics</td><td>Individual,institutional, REITand stockSizeand composition; investment</td><td></td></tr><tr><td>Hui, Zheng,and Wang (20l3） Applied economics</td><td>Financial Economics</td><td>market investors Risk-neutral, risk-averse,prperty</td><td>object and finance Investment behavior</td></tr><tr><td>Keys, Seru,and Vig (2012)</td><td></td><td>security and general security investors Subprime mortgage-backed security</td><td></td></tr><tr><td>Fisher and Lambie-Hanson</td><td>The Review of Financial Studies Real Estate Economics</td><td>investors; nonagency investors Local investors; nonlocal investors</td><td>Investment object and finance; size and composition Scale of operation</td></tr><tr><td>(2012) Korniotis and Kumar (2013)</td><td></td><td></td><td></td></tr><tr><td></td><td>The Journal of Finance</td><td>Nonlocal domestic investors; foreign investors</td><td>Scale of operation</td></tr><tr><td>Lee, Stevenson,and Lee (2014)</td><td>The Journal of Real Estate Institutional investors Finance and Economics</td><td></td><td>Size and composition</td></tr><tr><td>Ling, Naranjo,and Scheick (2014)</td><td>Real Estate Economics</td><td>Sentiment-driven investors</td><td>Investment behavior</td></tr><tr><td>Schindler (2014)</td><td>Finance and Economics</td><td>The Journal of Real Estate Private investors; institutional investors；Size and composition public institutions</td><td></td></tr><tr><td>Das, Ziobrowski, and</td><td></td><td>The Journal of Real Estate Institutional investors;sophisticated</td><td>Size and composition; investment</td></tr><tr><td>Coulson (2015) Duxbury et al. (2015)</td><td>Finance and Economics International Financial</td><td>large investors; REIT investors Individual investors; institutional</td><td>behavior Size and composition; investment</td></tr><tr><td></td><td>Markets, Institutions &amp;</td><td>investors</td><td>behavior</td></tr><tr><td>Piskorski, Seru,and Witkin</td><td>The Journal of Finance Money</td><td>Residential mortgage-backed securitiesInvestment object and finance</td><td></td></tr></table></body></html>

Appendix. (continued)   

<html><body><table><tr><td>Author/s (Year)</td><td>Journal</td><td>Type/s of Investors Mentioned</td><td>Assigned Meta-categorization</td></tr><tr><td>Qiao and Wong (2015)</td><td>Applied Economics</td><td>Risk-averse investors</td><td>Investment behavior</td></tr><tr><td>Wu and Tidwell (2015)</td><td>Applied Economics</td><td>Domestic investors; international investors</td><td>Scale of operation</td></tr><tr><td>Agarwal et al. (2016)</td><td>Review of Finance</td><td>Trend-chasing investors</td><td>Investment behavior</td></tr><tr><td>Chen and Harding (2016)</td><td>The Journal of Real Estate Portfolio investors Finance and Economics</td><td></td><td>Investment object and finance</td></tr><tr><td>Dieci and Westerhoff (20l6) Journal of Economic</td><td>Dynamics and Control</td><td>Boundedly rational housing market investors</td><td>Investment behavior</td></tr><tr><td>Zheng,Sun,and Kahn (2016)</td><td>Real Estate Economics</td><td>Levels of confidence of investors</td><td>Investment behavior</td></tr><tr><td>Zhou (2016)</td><td>Regional Science and Urban Economics</td><td>Long-term investors; short-term speculators</td><td>Investment behavior</td></tr><tr><td>Leung and Tse (2017)</td><td>Journal of Economic Dynamics and Control</td><td>Experienced flippers; cash-rich specialist; sophisticated + market-</td><td>Investment behavior</td></tr><tr><td>Maturana (2017)</td><td>The Review of Financial Studies</td><td>edge investors Residential mortgage-backed security investors</td><td>Investment behavior</td></tr><tr><td> Zheng et al. (2017)</td><td>Economic Modelling</td><td>Household buyers; speculative investors; property developers</td><td>Investment object and finance</td></tr><tr><td>Dieci, Schmitt and</td><td>Journal of Economic</td><td>Herding effects of investors</td><td>Investment behavior</td></tr><tr><td>Westerhoff (2018) Allen et al. (2018)</td><td>Dynamics and Control</td><td>The Journal of Real Estate Small,medium,large,institutional</td><td>Size and composition; investment</td></tr><tr><td>Badarinza and Ramadorai</td><td>Finance and Economics Journal of Financial</td><td>investors; private equity funds, REITs Overseas investors; wealthy (foreign</td><td>object and finance Scale of operation; size and</td></tr><tr><td>(2018) Huang (2018)</td><td>Economics International Review of</td><td>and local) private investors Risk-averse investors; forward-looking</td><td>composition</td></tr><tr><td>Seay et al. (2018)</td><td>Economics&amp; Finance Journal of Financial</td><td>investors</td><td>Investment behavior</td></tr><tr><td></td><td>Counselling and Planning</td><td>Novice/new investors</td><td>Size and composition</td></tr><tr><td>Mills, Molloy,and Zarutskie (2019)</td><td>Real Estate Economics</td><td>Individual and corporate investors (micro,small,medium,large, buy-to-rent)</td><td>Size and composition; investment object and finance</td></tr></table></body></html>

# Authors’ Note

The review was conducted as part of ongoing work within the framework of the WHIG Project (What Is Governed in Cities: Residential Investment Landscapes and the Governance and Regulation of Housing Production), which examines the interrelationships between contemporary investment flows into urban property markets and the governance arrangements and public policy instruments that are designed to regulate them (“What Is Governed in Cities? WHIG?” 2019).

# Declaration of Conflicting Interests

The author(s) declared no potential conflicts of interest with respect to the research, authorship, and/or publication of this article.

# Funding

The author(s) disclosed receipt of the following financial support for the research authorship, and/or publication of this article: The project What is Governed in Cities: Residential Investment Landscapes and the Governance and Regulation of Housing Production (https://whatisgoverne dincities.eu/) has received funding from the Open Research Area for the Social Sciences (ORA) under grant agreement no. 464.18.113.

# ORCID iD

Sara O¨ zogul $\textcircled{1}$ https://orcid.org/0000-0002-9011-7995

# Notes

1. The project (https://whatisgovernedincities.eu/) has received funding from the Open Research Area for the Social Sciences (ORA) under grant agreement no. 464.18.113.   
2. Web of Science search entry: (investor OR investment $\left( ^ { \ast } \$ 8 2 \right)$ ) AND (“residential property” OR real estate OR housing $( ^ { * } \$ 8 2 )$ ).   
3. A full overview of the results and own meta-categorization can be found in Appendix.

# References

Aalbers, Manuel. 2009. “Geographies of the Financial Crisis.” Area 41 (1): 34–42. doi: 10.1111/j.1475-4762.2008.00877.x.   
Aalbers, Manuel. 2017. “The Variegated Financialisation of Housing.” International Journal of Urban and Regional Research 41 (4): 542–54. doi: 10.1111/1468-2427.12522.   
Adams, David, and Steve Tiesdell. 2012a. Shaping Places: Urban Planning, Design and Development. New York: Routledge.   
Adams, David, and Steve Tiesdell. 2012b. Shaping Places: Urban Planning, Design and Development. London, UK: Routledge.   
Agarwal, Sumit, Yongheng Deng, Chenxi Luo, and Wenlan Qian. 2016. “The Hidden Peril: The Role of the Condo Loan Market in the Recent Financial Crisis.” Review of Finance 20 (2): 467–500. doi: 10.1093/rof/rfv015.   
Allen, Marcus T., Jessica Rutherford, Ronald Rutherford, and Abdullah Yavas. 2018. “Impact of Investors in Distressed Housing Markets.” The Journal of Real Estate Finance and Economics 56 (4): 622–52. doi: 10.1007/s11146-017-9609-0.   
Allon, Fiona, and Lindsay Barrett. 2018. “The Multiplication of the Margin: Price, Housing Wealth and Inequality.” Distinktion: Journal of Social Theory 19 (2): 117–34. doi: 10.1080/1600910X.2018. 1491874.   
August, Martine, and Alan Walks. 2018. “Gentrification, Suburban Decline, and the Financialization of Multi-family Rental Housing: The Case of Toronto.” Geoforum 89 (February): 124–36. doi: 10.1016/j.geoforum.2017.04.011.   
Badarinza, Cristian, and Tarun Ramadorai. 2018. “Home Away from Home? Foreign Demand and London House Prices.” Journal of Financial Economics 130 (3): 532–55. doi: 10.1016/j.jfineco.2018. 07.010.   
Benjamin, John D., Peter Chinloy, William G. Hardin, and Zhonghua Wu. 2008. “Clientele Effects and Condo Conversions.” Real Estate Economics 36 (3): 611–34. doi: 10.1111/j.1540-6229. 2008.00224.x.   
Bernt, Matthias, Laura Colini, and Daniel Fo¨ rste. 2017. “Privatization, Financialization and State Restructuring in Eastern Germany: The Case of Am Su¨dpark: Privatization, Financialization and State Restructuring in Eastern Germany.” International Journal of Urban and Regional Research 41 (4): 555–71. doi: 10.1111/ 1468-2427.12521.   
Berry, Mike. 2000. “Investment in Rental Housing in Australia: Small Landlords and Institutional Investors.” Housing Studies 15 (5): 661–81. doi: 10.1080/02673030050134547.   
Berry, Mike, and Jon Hall. 2005. “Institutional Investment in Rental Housing in Australia: A Policy Framework and Two Models.” Urban Studies 42 (1): 91–111. doi: 10.1080/0042098042000 309711.   
Bertus, Mark, Harris Hollans, and Steve Swidler. 2008. “Hedging House Price Risk with CME Futures Contracts: The Case of Las Vegas Residential Real Estate.” The Journal of Real Estate Finance and Economics 37 (3): 265–79. doi: 10.1007/s11146 -008-9129-z.   
Brenner, Neil. 1998. “Between Fixity and Motion: Accumulation, Territorial Organization and the Historical Geography of Spatial Scales.” Environment and Planning D: Society and Space 16 (4): 459–81. doi: 10.1068/d160459.   
Brenner, Neil. 2009. “A Thousand Leaves: Notes on the Geographies of Uneven Spatial Development.” In Leviathan Undone, edited by R. Keil and R. Mahon, 27–50. Vancouver: University of British Columbia Press.   
Brounen, Dirk, and Yair Ben-Hamo. 2009. “Calendar Anomalies: The Case of International Property Shares.” The Journal of Real Estate Finance and Economics 38 (2): 115–36. doi: 10.1007/s11146-007 -9088-9.   
Brown, Rayna, Rob Brown, Ian O’Connor, Gregory Schwann, and Callum Scott. 2011. “The Other Side of Housing Affordability: The User Cost of Housing in Australia: User Cost of Housing in Australia.” Economic Record 87 (279): 558–74. doi: 10.1111/j. 1475-4932.2011.00730.x.   
Brown, Rayna M., Gregory Schwann, and Callum Scott. 2008. “Personal Residential Real Estate Investment in Australia: Investor Characteristics and Investment Parameters.” Real Estate Economics 36 (1): 139–73. doi: 10.1111/j.1540-6229.2008.00210.x.   
Brunnermeier, Markus K., and Christian Julliard. 2008. “Money Illusion and Housing Frenzies.” Review of Financial Studies 21 (1): 135–80. doi: 10.1093/rfs/hhm043.   
Campbell, Heather, Malcolm Tait, and Craig Watkins. 2014. “Is There Space for Better Planning in a Neoliberal World? Implications for Planning Practice and Theory.” Journal of Planning Education and Research 34 (1): 45–59. doi: 10.1177/0739456X13514614.   
Charney, Igal. 2003. “Local Dimensions of Global Investment: Israeli Property Firms in Central Europe.” International Journal of Urban and Regional Research 27 (2): 441–47. doi: 10.1111/1468-2427. 00456.   
Chen, Tao, and John P. Harding. 2016. “Changing Tastes: Estimating Changing Attribute Prices in Hedonic and Repeat Sales Models.” The Journal of Real Estate Finance and Economics 52 (2): 141–75. doi: 10.1007/s11146-015-9497-0.   
Cheng, Ping. 2005. “Asymmetric Risk Measures and Real Estate Returns.” The Journal of Real Estate Finance and Economics 30 (1): 89–102. doi: 10.1007/s11146-004-4833-9.   
Chernobai, Ekaterina, and Tarique Hossain. 2012. “House Search Duration in Hot and Cold Residential Markets: House Search Duration in Hot and Cold Residential Markets.” Real Estate Economics 40 (4): 809–41. doi: 10.1111/j.1540-6229.2012.00329.x.   
Chilton, Ken, Robert Silverman, Rabia Chaudhrey, and Chihaungji Wang. 2018. “The Impact of Single-family Rental REITs on Regional Housing Markets: A Case Study of Nashville, TN.” Societies 8 (4): 93. doi: 10.3390/soc8040093.   
Cho, Youngha, Soosung Hwang, and Steve Satchell. 2012. “The Optimal Mortgage Loan Portfolio in UK Regional Residential Real Estate.” The Journal of Real Estate Finance and Economics 45 (3): 645–77. doi: 10.1007/s11146-010-9269-9.   
Clapp, John M., Gerson M. Goldberg, John P. Harding, and Michael LaCour-Little. 2001. “Movers and Shuckers: Interdependent Prepayment Decisions.” Real Estate Economics 29 (3): 411–50. doi: 10.1111/1080-8620.00017.   
Clark, G. L., R. Duran-Fernandez, and K. Strauss. 2010. “‘Being in the Market’: The UK House-price Bubble and the Intended Structure of Individual Pension Investment Portfolios.” Journal of Economic Geography 10 (3): 331–59. doi: 10.1093/jeg/lbp034.   
Cocco, Joa˜o F. 2005. “Portfolio Choice in the Presence of Housing.” Review of Financial Studies 18 (2): 535–67. doi: 10.1093/rfs/ hhi006.   
Coiacetto, Eddo, and Lyndall Bryant. 2014. “How Does Access to Development Finance Shape Our Cities?” Urban Policy and Research 32 (3): 305–21. doi: 10.1080/08111146.2014.924922.   
Cook, Andrew. 2010. “The Expatriate Real Estate Complex: Creative Destruction and the Production of Luxury in Post-socialist Prague: Creative Destruction and the Production of Luxury in Post-socialist Prague.” International Journal of Urban and Regional Research 34 (3): 611–28. doi: 10.1111/j.1468-2427.2010.00912.x.   
Cooper, Michael, David H. Downs, and Gary A. Patterson. 2000 “Asymmetric Information and the Predictability of Real Estate Returns.” The Journal of Real Estate Finance and Economics 20: 225–44.   
Das, Prashant, Alan Ziobrowski, and N. Edward Coulson. 2015. “Online Information Search, Market Fundamentals and Apartment Real Estate.” The Journal of Real Estate Finance and Economics 51 (4): 480–502. doi: 10.1007/s11146-015-9496-1.   
DeVerteuil, Geoffrey, and David Manley. 2017. “Overseas Investment into London: Imprint, Impact and Pied-\`a-Terre Urbanism.” Environment and Planning A 49 (6): 1308–23. doi: 10.1177/ 0308518X17694361.   
Diappi, Lidia, and Paola Bolchi. 2008. “Smith’s Rent Gap Theory and Local Real Estate Dynamics: A Multi-agent Model.” Computers, Environment and Urban Systems 32 (1): 6–18. doi: 10.1016/j. compenvurbsys.2006.11.003.   
Dieci, Roberto, Noemi Schmitt, and Frank Westerhoff. 2018. “Interactions between Stock, Bond and Housing Markets.” Journal of Economic Dynamics and Control 91 (June): 43–70. doi: 10. 1016/j.jedc.2018.05.001.   
Dieci, Roberto, and Frank Westerhoff. 2016. “Heterogeneous Expectations, Boom-bust Housing Cycles, and Supply Conditions: A Nonlinear Economic Dynamics Approach.” Journal of Economic Dynamics and Control 71 (October): 21–44. doi: 10.1016/j.jedc. 2016.07.011.   
Dixon, Megan. 2010. “Emerging Chinese Role in Shaping St. Petersburg’s Urban Landscape: Interscalar Investment Strategies in the Development of a Residential Megaproject.” Eurasian Geography and Economics 51 (6): 803–19. doi: 10.2747/1539-7216.51.6.803.   
Duxbury, Darren, Robert Hudson, Kevin Keasey, Zhishu Yang, and Songyao Yao. 2015. “Do the Disposition and House Money Effects Coexist? A Reconciliation of Two Behavioral Biases Using Individual Investor-level Data.” Journal of International Financial Markets, Institutions and Money 34 (January): 55–68. doi: 10.1016/j.intfin.2014.11.004.   
Earl, Peter E., Ti-Ching Peng, and Jason Potts. 2007. “Decision-rule Cascades and the Dynamics of Speculative Bubbles.” Journal of Economic Psychology 28 (3): 351–64. doi: 10.1016/j.joep.2006.08. 001.   
Eichholtz, Piet M. A., Nils Gugler, and Nils Kok. 2011. “Transparency, Integration, and the Cost of International Real Estate Investments.” The Journal of Real Estate Finance and Economics 43 (1–2): 152–73. doi: 10.1007/s11146-010-9244-5.   
Fernandez, Rodrigo, Annelore Hofman, and Manuel B. Aalbers. 2016. “London and New York as a Safe Deposit Box for the Transnational Wealth Elite.” Environment and Planning A: Economy and Space 48 (12): 2443–61. doi: 10.1177/0308518X16659479.   
Fields, Desiree. 2017. “Urban Struggles with Financialization.” Geography Compass 11 (11): e12334. doi: 10.1111/gec3.12334.   
Fields, Desiree. 2018. “Constructing a New Asset Class: Property-led Financial Accumulation after the Crisis.” Economic Geography 94 (2): 118–40. doi: 10.1080/00130095.2017.1397492.   
Fields, Desiree, and Sabina Uffer. 2016. “The Financialisation of Rental Housing: A Comparative Analysis of New York City and Berlin.” Urban Studies 53 (7): 1486–502. doi: 10.1177/00420 98014543704.   
Fisher, Jeffrey, David C. Ling, and Andy Naranjo. 2009. “Institutional Capital Flows and Return Dynamics in Private Commercial Real Estate Markets.” Real Estate Economics 37 (1): 85–116. doi: 10.1111/j.1540-6229.2009.00236.x.   
Fisher, Lynn M., and Lauren Lambie-Hanson. 2012. “Are Investors the Bad Guys? Tenure and Neighborhood Stability in Chelsea, Massachusetts: Are Investors the Bad Guys.” Real Estate Economics 40 (2): 351–86. doi: 10.1111/j.1540-6229.2011.00317.x.   
Gillon, Charles, and Chris Gibson. 2018. “Calculated Homes, Stretched Emotions: Unmasking ‘Rational’ Investor-occupier Subjects in Large Family Homes in a Coastal Sydney Development.” Emotion, Space and Society 26 (February): 23–30. doi: 10.1016/j. emospa.2018.01.001.   
Goldstein, Adam. 2018. “The Social Ecology of Speculation: Community Organization and Non-occupancy Investment in the U.S. Housing Bubble.” American Sociological Review 83 (6): 1108–43. doi: 10.1177/0003122418808212.   
Guironnet, Antoine, Katia Attuyer, and Ludovic Halbert. 2016. “Building Cities on Financial Assets: The Financialisation of Property Markets and Its Implications for City Governments in the Paris City-region.” Urban Studies 53 (7): 1442–64. doi: 10.1177/00420 98015576474.   
Hardin, William G., Xiaoquan Jiang, and Zhonghua Wu. 2012. “REIT Stock Prices with Inflation Hedging and Illusion.” The Journal of Real Estate Finance and Economics 45 (1): 262–87. doi: 10.1007/ s11146-010-9259-y.   
Harvey, David. 1989. “From Managerialism to Entrepreneurialism: The Transformation in Urban Governance in Late Capitalism.” Geografiska Annaler: Series B, Human Geography 71 (1): 3–17. doi: 10.1080/04353684.1989.11879583.   
Hayunga, Darren K., and Peter P. Lung. 2011. “Explaining Asset Mispricing Using the Resale Option and Inflation Illusion: Explaining Asset Mispricing Using the Resale Option and Inflation Illusion.” Real Estate Economics 39 (2): 313–44. doi: 10.1111/j. 1540-6229.2010.00297.x.   
He, Canfei, Junsong Wang, and Shaoming Cheng. 2011. “What Attracts Foreign Direct Investment in China’s Real Estate Development?” The Annals of Regional Science 46 (2): 267–93. doi: 10.1007/s00168-009-0341-4.   
Hei-Ling Lam, Charles, and Eddie Chi-Man Hui. 2018. “How Does Investor Sentiment Predict the Future Real Estate Returns of Residential Property in Hong Kong?” Habitat International 75 (May): 1–11. doi: 10.1016/j.habitatint.2018.02.009.   
Ho, Hang K., and Rowland Atkinson. 2018. “Looking for Big ‘Fry’: The Motives and Methods of Middle-class International Property Investors.” Urban Studies 55 (9): 2040–56. doi: 10.1177/ 0042098017702826.   
Hoang, Kimberly Kay. 2018. “Risky Investments: How Local and Foreign Investors Finesse Corruption-rife Emerging Markets.” American Sociological Review 83 (4): 657–85. doi: 10.1177/ 0003122418782476.   
Huang, MeiChi. 2018. “Time-varying Diversification Strategies: The Roles of State-level Housing Assets in Optimal Portfolios.” International Review of Economics & Finance 55 (May): 145–72. doi: 10.1016/j.iref.2018.02.001.   
Hui, Eddie Chi-man, and Ziyou Wang. 2014. “Market Sentiment in Private Housing Market.” Habitat International 44 (October): 375–85. doi: 10.1016/j.habitatint.2014.08.001.   
Hui, Eddie Chi-man, Xian Zheng, and Hui Wang. 2013. “Investor Sentiment and Risk Appetite of Real Estate Security Market.” Applied Economics 45 (19): 2801–7. doi: 10.1080/00036846. 2012.681028.   
Hulse, Kath, and Margaret Reynolds. 2018. “Investification: Financialisation of Housing Markets and Persistence of Suburban Socio-economic Disadvantage.” Urban Studies 55 (8): 1655–71. doi: 10.1177/0042098017734995.   
Hwang, Min, and John M. Quigley. 2010. “Housing Price Dynamics in Time and Space: Predictability, Liquidity and Investor Returns.” The Journal of Real Estate Finance and Economics 41 (1): 3–23. doi: 10.1007/s11146-009-9207-x.   
Immergluck, Dan. 2009. “The Foreclosure Crisis, Foreclosed Properties, and Federal Policy: Some Implications for Housing and Community Development Planning.” Journal of the American Planning Association 75 (4): 406–23. doi: 10.1080/01944360903124316.   
Immergluck, Dan, and Jonathan Law. 2014. “Speculating in Crisis: The Intrametropolitan Geography of Investing in Foreclosed Homes in Atlanta.” Urban Geography 35 (1): 1–24. doi: 10.1080/02723638. 2013.858510.   
Jacob, Elin K. 2004. “Classification and Categorization: A Difference That Makes a Difference.” Library Trends 52 (3): 515–40.   
Keogh, Geoffrey, and Eamonn D’Arcy. 1999. “Property Market Efficiency: An Institutional Economics Perspective.” Urban Studies 36 (13): 2401–14. doi: 10.1080/0042098992485.   
Keys, Benjamin J., Amit Seru, and Vikrant Vig. 2012. “Lender Screening and the Role of Securitization: Evidence from Prime and Subprime Mortgage Markets.” Review of Financial Studies 25 (7): 2071–2108. doi: 10.1093/rfs/hhs059.   
Kim, Hyung Min. 2017. “Ethnic Connections, Foreign Housing Investment and Locality: A Case Study of Seoul.” International Journal of Housing Policy 17 (1): 120–44. doi: 10.1080/14616718. 2016.1189683.   
Kim, Hyung Min, Sun Sheng Han, and Kevin B. O’Connor. 2015. “Foreign Housing Investment in Seoul: Origin of Investors and Location of Investment.” Cities 42 (February): 212–23. doi: 10. 1016/j.cities.2014.07.006.   
Korniotis, George M., and Alok Kumar. 2013. “State-level Business Cycles and Local Return Predictability: State-level Business Cycles and Local Return Predictability.” The Journal of Finance 68 (3): 1037–96. doi: 10.1111/jofi.12017.   
Kriese, Ulrich, and Roland W. Scholz. 2012. “Lifestyle Ideas of House Builders and Housing Investors.” Housing, Theory and Society 29 (3): 288–320. doi: 10.1080/14036096.2011.629679.   
Lambie-Hanson, Lauren, Christopher E. Herbert, Irene Lew, and Rocio Sanchez-Moyano. 2019. “Foreclosed Property Investors in a Strong Housing Market City: A Case Study of Boston.” Cityscape 17 (2): 239–68.   
Lee, Chyi Lin, Simon Stevenson, and Ming-Long Lee. 2014. “Futures Trading, Spot Price Volatility and Market Efficiency: Evidence from European Real Estate Securities Futures.” The Journal of Real Estate Finance and Economics 48 (2): 299–322. doi: 10.1007/ s11146-012-9399-3.   
Leung, Charles Ka Yui, and Chung-Yi Tse. 2017. “Flipping in the Housing Market.” Journal of Economic Dynamics and Control 76 (March): 232–63. doi: 10.1016/j.jedc.2017.01.003.   
Ley, David. 2017. “Global China and the Making of Vancouver’s Residential Property Market.” International Journal of Housing Policy 17 (1): 15–34. doi: 10.1080/14616718.2015.1119776.   
Lin, Zhenguo, and Kerry D. Vandell. 2007. “Illiquidity and Pricing Biases in the Real Estate Market.” Real Estate Economics 35 (3): 291–330. doi: 10.1111/j.1540-6229.2007.00191.x.   
Ling, David C., Andy Naranjo, and Benjamin Scheick. 2014. “Investor Sentiment, Limits to Arbitrage and Private Market Returns: Investor Sentiment, Limits to Arbitrage and Private Market Returns.” Real Estate Economics 42 (3): 531–77. doi: 10.1111/ 1540-6229.12037.   
Mallach, Alan. 2014. “Lessons from Las Vegas: Housing Markets, Neighborhoods, and Distressed Single-family Property Investors.” Housing Policy Debate 24 (4): 769–801. doi: 10.1080/10511482. 2013.872160.   
Martin, Chris. 2017. “Clever Odysseus: Narratives and Strategies of Rental Property Investor Subjectivity in Australia.” Housing Studies 33 (7): 1060–84. doi: 10.1080/02673037.2017.1414161.   
Massey, Doreen. 2004. “Geographies of Responsibility.” Geografiska Annaler. Series B, Human Geography 86 (1): 5–18.   
Maturana, Gonzalo. 2017. “When Are Modifications of Securitized Loans Beneficial to Investors?” The Review of Financial Studies 30 (11): 3824–57. doi: 10.1093/rfs/hhx053.   
McGregor, JoAnn. 2014. “Sentimentality or Speculation? Diaspora Investment, Crisis Economies and Urban Transformation.” Geoforum 56 (September): 172–81. doi: 10.1016/j.geoforum.2014.07. 008.   
Mills, James, Raven Molloy, and Rebecca Zarutskie. 2019. “Largescale Buy-to-rent Investors in the Single-family Housing Market: The Emergence of a New Asset Class.” Real Estate Economics 47 (2): 399–430. doi: 10.1111/1540-6229.12189.   
Mok, Diana. 2002. “Sharing the Risk of Home-ownership: A Portfolio Approach.” Urban Studies 39(7): 1095–1112.   
Molina, Emily T. 2016. “Foreclosures, Investors, and Uneven Development during the Great Recession in the Los Angeles Metropolitan Area.” Journal of Urban Affairs 38 (4): 564–80. doi: 10.1111/ juaf.12258.   
Montezuma, Joaquim. 2006. “A Survey of Institutional Investors’ Attitudes and Perceptions of Residential Property: The Swiss, Dutch and Swedish Cases.” Housing Studies 21 (6): 883–908. doi: 10.1080/02673030600917818.   
Nappi-Choulet, Ingrid. 2006. “The Role and Behaviour of Commercial Property Investors and Developers in French Urban Regeneration: The Experience of the Paris Region.” Urban Studies 43 (9): 1511–35.   
Oikarinen, Elias. 2010. “Foreign Ownership of Stocks and Long-run Interdependence Between National Housing and Stock Markets— Evidence from Finnish Data.” The Journal of Real Estate Finance and Economics 41 (4): 486–509. doi: 10.1007/s11146-009-9175-1.   
Okoli, Chitu. 2015. “A Guide to Conducting a Standalone Systematic Literature Review.” Communications of the Association for Information Systems 37 (1): 879–910. doi: 10.17705/1CAIS.03743.   
Pagliari, Joseph L., Kevin A. Scherer, and Richard T. Monopoli. 2005. “Public versus Private Real Estate Equities: A More Refined, Long-term Comparison.” Real Estate Economics 33 (1): 147–87. doi: 10.1111/j.1080-8620.2005.00115.x.   
Pfeiffer, Deirdre, and Joanna Lucio. 2015. “An Unexpected Geography of Opportunity in the Wake of the Foreclosure Crisis: Lowincome Renters in Investor-purchased Foreclosures in Phoenix, Arizona.” Urban Geography 36 (8): 1197–220. doi: 10.1080/ 02723638.2015.1053201.   
Piskorski, Tomasz, Amit Seru, and James Witkin. 2015. “Asset Quality Misrepresentation by Financial Intermediaries: Evidence from the RMBS Market: Asset Quality Misrepresentation by Financial Intermediaries.” The Journal of Finance 70 (6): 2635–78. doi: 10.1111/jofi.12271.   
Qiao, Zhuo, and Wing-Keung Wong. 2015. “Which Is a Better Investment Choice in the Hong Kong Residential Property Market: A Big or Small Property?” Applied Economics 47 (16): 1670–85. doi: 10. 1080/00036846.2014.1000534.   
Quigley, John M. 2006. “Real Estate Portfolio Allocation: The European Consumers’ Perspective.” Journal of Housing Economics 15 (3): 169–88. doi: 10.1016/j.jhe.2006.09.003.   
Raco, Mike, Nicola Livingstone, and Daniel Durrant. 2019. “Seeing Like an Investor: Urban Development Planning, Financialisation, and Investors’ Perceptions of London as an Investment Space.” European Planning Studies 27 (6): 1064–82. doi: 10.1080/0965 4313.2019.1598019.   
Rogers, Dallas, and Sin Yee Koh. 2017. “The Globalisation of Real Estate: The Politics and Practice of Foreign Real Estate Investment.” International Journal of Housing Policy 17 (1): 1–14. doi: 10.1080/19491247.2016.1270618.   
Rogers, Dallas, Chyi Lin Lee, and Ding Yan. 2015. “The Politics of Foreign Investment in Australian Housing: Chinese Investors, Translocal Sales Agents and Local Resistance.” Housing Studies 30 (5): 730–48. doi: 10.1080/02673037.2015.1006185.   
Rogers, Dallas, Jacqueline Nelson, and Alexandra Wong. 2018. “Geographies of Hyper-commodified Housing: Foreign Capital, Market Activity, and Housing Stress: Geographies of Hypercommodified Housing.” Geographical Research 56 (4): 434–46. doi: 10.1111/1745-5871.12280.   
Rogers, Dallas, Alexandra Wong, and Jacqueline Nelson. 2017. “Public Perceptions of Foreign and Chinese Real Estate Investment: Intercultural Relations in Global Sydney.” Australian Geographer 48 (4): 437–55. doi: 10.1080/00049182.2017.1317050.   
Rosato, Paolo, Anna Alberini, Valentina Zanatta, and Margaretha Breil. 2010. “Redeveloping Derelict and Underused Historic City Areas: Evidence from a Survey of Real Estate Developers.” Journal of Environmental Planning and Management 53 (2): 257–81. doi: 10.1080/09640560903529550.   
Rosch, Eleanor. 1975. “Cognitive Representations of Semantic Categories.” Journal of Experimental Psychology: General 104 (3): 192–233.   
Sassen, Saskia. 2009. “When Local Housing Becomes an Electronic Instrument: The Global Circulation of Mortgages: A Research Note.” International Journal of Urban and Regional Research 33 (2): 411–26. doi: 10.1111/j.1468-2427.2009.00868.x.   
Sassen, Saskia. 2015. “Who Owns Our Cities and Why This Urban Takeover Should Concern Us All | Cities.” The Guardian. Accessed April 21, 2020. https://www.theguardian.com/cities/ 2015/nov/24/who-owns-our-cities-and-why-this-urban-takeovershould-concern-us-all.   
Savini, Federico, and Manuel B. Aalbers. 2016. “The Decontextualisation of Land Use Planning through Financialisation: Urban Redevelopment in Milan.” European Urban and Regional Studies 23 (4): 878–94. doi: 10.1177/0969776415585887.   
Schindler, Felix. 2014. “Persistence and Predictability in UK House Price Movements.” The Journal of Real Estate Finance and Economics 48 (1): 132–63. doi: 10.1007/s11146-012-9384-x.   
Searle, Llerena Guiu. 2014. “Conflict and Commensuration: Contested Market Making in India’s Private Real Estate Development Sector: India’s Private Real Estate Development Sector.” International Journal of Urban and Regional Research 38 (1): 60–78. doi: 10.1111/1468-2427.12042.   
Seay, Martin C., Somer G. Anderson, Andy T. Carswell, and Robert B. Nielsen. 2018. “Characteristics of Rental Real Estate Investors during the 2000s.” Journal of Financial Counseling and Planning 29 (2): 369–82. doi: 10.1891/1052-3073.29.2.369.   
Sheng, Yap Kioe, and Sakchai Kirinpanu. 2000. “Once Only the Sky Was the Limit: Bangkok’s Housing Boom and the Financial Crisis in Thailand.” Housing Studies 15 (1): 11–27. doi: 10.1080/ 02673030082441.   
Smith, Susan J. 2008. “Owner-occupation: At Home with a Hybrid of Money and Materials.” Environment and Planning A: Economy and Space 40 (3): 520–35. doi: 10.1068/a38423.   
Stevens, Bryony. 2016. “Strategic Intervention for the Economically Active? Exploring the Role of Selected English Local Authorities in the Development of New Market Rental Housing with Pension Fund Investment.” Journal of Housing and the Built Environment 31 (1): 107–22. doi: 10.1007/s10901-015-9447-4.   
Tang, Connie P. Y., Michael Oxley, and Daniel Mekic. 2017. “Meeting Commercial and Social Goals: Institutional Investment in the Housing Association Sector.” Housing Studies 32 (4): 411–27. doi: 10.1080/02673037.2016.1210098.   
Teresa, Benjamin F. 2016. “Managing Fictitious Capital: The Legal Geography of Investment and Political Struggle in Rental Housing in New York City.” Environment and Planning A: Economy and Space 48 (3): 465–84. doi: 10.1177/0308518X15598322.   
Theurillat, Thierry, Jose Corpataux, and Olivier Crevoisier. 2010. “Property Sector Financialization: The Case of Swiss Pension Funds (1992–2005).” European Planning Studies 18 (2): 189–212.   
Theurillat, Thierry, Patrick R´erat, and Olivier Crevoisier. 2015. “The Real Estate Markets: Players, Institutions and Territories.” Urban Studies 52 (8): 1414–33.   
Thien Thu, Truong, and Ranjith Perera. 2011. “Consequences of the Two-price System for Land in the Land and Housing Market in Ho Chi Minh City, Vietnam.” Habitat International 35 (1): 30–39. doi: 10.1016/j.habitatint.2010.03.005.   
Tomaskovic-Devey, Donald, and Ken-Hou Lin. 2011 “Income Dynamics, Economic Rents, and the Financialization of the US Economy.” American Sociological Review 76 (4): 538–55.   
Van Hemert, Otto. 2010. “Household Interest Rate Risk Management: Household Interest Rate Risk Management.” Real Estate Economics 38 (3): 467–505. doi: 10.1111/j.1540-6229.2010.00274.x.   
Van Loon, Jannes, and Manuel B. Aalbers. 2017. “How Real Estate Became ‘Just Another Asset Class’: The Financialisation of the Investment Strategies of Dutch Institutional Investors.” European Planning Studies 25 (2): 221–40. doi: 10.1080/09654313.2016. 1277693.   
Voigtla¨nder, Michael. 2009. “Why Is the German Homeownership Rate so Low?” Housing Studies 24 (3): 355–72. doi: 10.1080/ 02673030902875011.   
Wainwright, Thomas, and Graham Manville. 2017. “Financialization and the Third Sector: Innovation in Social Housing Bond Markets.” Environment and Planning A 49 (4): 819–38. doi: 10.1177/0308 518X16684140.   
Waldron, Richard. 2018. “Capitalizing on the State: The Political Economy of Real Estate Investment Trusts and the ‘Resolution’ of the Crisis.” Geoforum 90 (March): 206–18. doi: 10.1016/j.geo forum.2018.02.014.   
Walks, Alan, and Brian Clifford. 2015. “The Political Economy of Mortgage Securitization and the Neoliberalization of Housing Policy in Canada.” Environment and Planning A: Economy and Space 47 (8): 1624–42. doi: 10.1068/a130226p.   
Watson, Matthew. 2010. “House Price Keynesianism and the Contradictions of the Modern Investor Subject.” Housing Studies 25 (3): 413–26. doi: 10.1080/02673031003711550.   
“What Is Governed in Cities?—WHIG?”. 2019. “WHIG Project 2019.” Accessed April 21, 2020. https://whatisgovernedinci ties.eu/.   
Wiesel, Ilan, and Iris Levin. 2018. “Cohesion and Differentiation in Australia’s Elite Suburbs: Australia’s Elite Suburbs.” Geographical Research 56 (4): 410–20. doi: 10.1111/1745-5871. 12268.   
Wissoker, Peter. 2016. “Putting the Supplier in Housing Supply: An Overview of the Growth and Concentration of Large Homebuilders in the United States (1990–2007).” Housing Policy Debate 26 (3): 536–62. doi: 10.1080/10511482.2015.1115418.   
Wood, Gavin A., and Rachel Ong. 2013. “When and Why Do Landlords Retain Property Investments?” Urban Studies 50 (16): 3243–61. doi: 10.1177/0042098013484544.   
Wood, Gavin A., and Yong Tu. 2004. “Are There Investor Clienteles in Rental Housing?” Real Estate Economics 32 (3): 413–36. doi: 10.1111/j.1080-8620.2004.00097.x.   
Wu, Yi, and Alan Tidwell. 2015. “Inflation-hedging Properties of Regional Chinese Real Estate Market: Evidence from 35 Cities in China.” Applied Economics 47 (60): 6580–98. doi: 10.1080/ 00036846.2015.1080811.   
Zheng, Min, Hefei Wang, Chengzhang Wang, and Shouyang Wang. 2017. “Speculative Behavior in a Housing Market: Boom and Bust.” Economic Modelling 61 (February): 50–64. doi: 10.1016/j.econmod. 2016.11.021.   
Zheng, Siqi, Weizeng Sun, and Matthew E. Kahn. 2016. “Investor Confidence as a Determinant of China’s Urban Housing Market Dynamics: Investor Confidence as a Determinant of China’s Urban Housing Market Dynamics.” Real Estate Economics 44 (4): 814–45. doi: 10.1111/1540-6229.12119.   
Zhou, Zhengyi. 2016. “Overreaction to Policy Changes in the Housing Market: Evidence from Shanghai.” Regional Science and Urban Economics 58 (May): 26–41. doi: 10.1016/j.regsciurbeco.2016. 02.004.

# Author Biographies

Sara O¨ zogul (BA, MSc, PhD) is postdoctoral researcher in the Department of Geography, Planning and International Development Studies, University of Amsterdam. Her research centres around spatial planning and governance complexities, which she approaches from several angles including social policy and property-driven urban development.

Tuna Tasan-Kok (BA, MSc, PhD) is professor of Urban Governance and Planning in the Department of Geography, Planning and International Development Studies, University of Amsterdam. Her research mainly focuses on urban governance, particularly on entrepreneurial and property-led forms of urban development dynamics, and spatial organisation through social relations.